/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.LogsListRequestPage;
import com.datadog.api.client.v2.model.LogsQueryFilter;
import com.datadog.api.client.v2.model.LogsQueryOptions;
import com.datadog.api.client.v2.model.LogsSort;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"filter", "options", "page", "sort"})
public class LogsListRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FILTER = "filter";
    private LogsQueryFilter filter;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private LogsQueryOptions options;
    public static final String JSON_PROPERTY_PAGE = "page";
    private LogsListRequestPage page;
    public static final String JSON_PROPERTY_SORT = "sort";
    private LogsSort sort;

    public LogsListRequest filter(LogsQueryFilter filter) {
        this.filter = filter;
        this.unparsed |= filter.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsQueryFilter getFilter() {
        return this.filter;
    }

    public void setFilter(LogsQueryFilter filter) {
        this.filter = filter;
    }

    public LogsListRequest options(LogsQueryOptions options) {
        this.options = options;
        this.unparsed |= options.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsQueryOptions getOptions() {
        return this.options;
    }

    public void setOptions(LogsQueryOptions options) {
        this.options = options;
    }

    public LogsListRequest page(LogsListRequestPage page) {
        this.page = page;
        this.unparsed |= page.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsListRequestPage getPage() {
        return this.page;
    }

    public void setPage(LogsListRequestPage page) {
        this.page = page;
    }

    public LogsListRequest sort(LogsSort sort) {
        this.sort = sort;
        this.unparsed |= !sort.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsSort getSort() {
        return this.sort;
    }

    public void setSort(LogsSort sort) {
        if (!sort.isValid()) {
            this.unparsed = true;
        }
        this.sort = sort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsListRequest logsListRequest = (LogsListRequest)o;
        return Objects.equals(this.filter, logsListRequest.filter) && Objects.equals(this.options, logsListRequest.options) && Objects.equals(this.page, logsListRequest.page) && Objects.equals(this.sort, logsListRequest.sort);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.options, this.page, this.sort);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsListRequest {\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

