/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"code", "details", "message"})
public class LogsAPIError {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CODE = "code";
    private String code;
    public static final String JSON_PROPERTY_DETAILS = "details";
    private List<LogsAPIError> details = null;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;

    public LogsAPIError code(String code) {
        this.code = code;
        return this;
    }

    @Nullable
    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public LogsAPIError details(List<LogsAPIError> details) {
        this.details = details;
        for (LogsAPIError item : details) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public LogsAPIError addDetailsItem(LogsAPIError detailsItem) {
        if (this.details == null) {
            this.details = new ArrayList<LogsAPIError>();
        }
        this.details.add(detailsItem);
        this.unparsed |= detailsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="details")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LogsAPIError> getDetails() {
        return this.details;
    }

    public void setDetails(List<LogsAPIError> details) {
        this.details = details;
    }

    public LogsAPIError message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsAPIError logsApiError = (LogsAPIError)o;
        return Objects.equals(this.code, logsApiError.code) && Objects.equals(this.details, logsApiError.details) && Objects.equals(this.message, logsApiError.message);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.details, this.message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsAPIError {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

