/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=MetricCustomSpaceAggregationSerializer.class)
public class MetricCustomSpaceAggregation {
    public static final MetricCustomSpaceAggregation AVG = new MetricCustomSpaceAggregation("avg");
    public static final MetricCustomSpaceAggregation MAX = new MetricCustomSpaceAggregation("max");
    public static final MetricCustomSpaceAggregation MIN = new MetricCustomSpaceAggregation("min");
    public static final MetricCustomSpaceAggregation SUM = new MetricCustomSpaceAggregation("sum");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("avg", "max", "min", "sum"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    MetricCustomSpaceAggregation(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((MetricCustomSpaceAggregation)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static MetricCustomSpaceAggregation fromValue(String value) {
        return new MetricCustomSpaceAggregation(value);
    }

    public static class MetricCustomSpaceAggregationSerializer
    extends StdSerializer<MetricCustomSpaceAggregation> {
        public MetricCustomSpaceAggregationSerializer(Class<MetricCustomSpaceAggregation> t) {
            super(t);
        }

        public MetricCustomSpaceAggregationSerializer() {
            this(null);
        }

        public void serialize(MetricCustomSpaceAggregation value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

