/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.EventResponse;
import com.datadog.api.client.v2.model.EventsListRequest;
import com.datadog.api.client.v2.model.EventsListResponse;
import com.datadog.api.client.v2.model.EventsRequestPage;
import com.datadog.api.client.v2.model.EventsSort;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;

public class EventsApi {
    private ApiClient apiClient;

    public EventsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public EventsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public EventsListResponse listEvents() throws ApiException {
        return this.listEventsWithHttpInfo(new ListEventsOptionalParameters()).getData();
    }

    public CompletableFuture<EventsListResponse> listEventsAsync() {
        return this.listEventsWithHttpInfoAsync(new ListEventsOptionalParameters()).thenApply(response -> (EventsListResponse)response.getData());
    }

    public EventsListResponse listEvents(ListEventsOptionalParameters parameters) throws ApiException {
        return this.listEventsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<EventsListResponse> listEventsAsync(ListEventsOptionalParameters parameters) {
        return this.listEventsWithHttpInfoAsync(parameters).thenApply(response -> (EventsListResponse)response.getData());
    }

    public PaginationIterable<EventResponse> listEventsWithPagination() throws ApiException {
        ListEventsOptionalParameters parameters = new ListEventsOptionalParameters();
        return this.listEventsWithPagination(parameters);
    }

    public PaginationIterable<EventResponse> listEventsWithPagination(ListEventsOptionalParameters parameters) throws ApiException {
        Integer limit;
        String resultsPath = "getData";
        String valueGetterPath = "getMeta.getPage.getAfter";
        String valueSetterPath = "pageCursor";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageLimit == null) {
            limit = 10;
            parameters.pageLimit(limit);
        } else {
            limit = parameters.pageLimit;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<EventResponse> iterator = new PaginationIterable<EventResponse>(this, "listEvents", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, limit, args);
        return iterator;
    }

    public ApiResponse<EventsListResponse> listEventsWithHttpInfo(ListEventsOptionalParameters parameters) throws ApiException {
        String operationId = "listEvents";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String filterQuery = parameters.filterQuery;
        String filterFrom = parameters.filterFrom;
        String filterTo = parameters.filterTo;
        EventsSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.EventsApi.listEvents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<EventsListResponse>(){});
    }

    public CompletableFuture<ApiResponse<EventsListResponse>> listEventsWithHttpInfoAsync(ListEventsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listEvents";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<EventsListResponse>> result = new CompletableFuture<ApiResponse<EventsListResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String filterQuery = parameters.filterQuery;
        String filterFrom = parameters.filterFrom;
        String filterTo = parameters.filterTo;
        EventsSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        try {
            builder = this.apiClient.createBuilder("EventsApi.listEvents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<EventsListResponse>> result = new CompletableFuture<ApiResponse<EventsListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<EventsListResponse>(){});
    }

    public EventsListResponse searchEvents() throws ApiException {
        return this.searchEventsWithHttpInfo(new SearchEventsOptionalParameters()).getData();
    }

    public CompletableFuture<EventsListResponse> searchEventsAsync() {
        return this.searchEventsWithHttpInfoAsync(new SearchEventsOptionalParameters()).thenApply(response -> (EventsListResponse)response.getData());
    }

    public EventsListResponse searchEvents(SearchEventsOptionalParameters parameters) throws ApiException {
        return this.searchEventsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<EventsListResponse> searchEventsAsync(SearchEventsOptionalParameters parameters) {
        return this.searchEventsWithHttpInfoAsync(parameters).thenApply(response -> (EventsListResponse)response.getData());
    }

    public PaginationIterable<EventResponse> searchEventsWithPagination() throws ApiException {
        SearchEventsOptionalParameters parameters = new SearchEventsOptionalParameters();
        return this.searchEventsWithPagination(parameters);
    }

    public PaginationIterable<EventResponse> searchEventsWithPagination(SearchEventsOptionalParameters parameters) throws ApiException {
        Integer limit;
        String resultsPath = "getData";
        String valueGetterPath = "getMeta.getPage.getAfter";
        String valueSetterPath = "body.getPage.setCursor";
        Boolean valueSetterParamOptional = true;
        if (parameters.body == null) {
            parameters.body(new EventsListRequest());
        }
        if (parameters.body.getPage() == null) {
            parameters.body.setPage(new EventsRequestPage());
        }
        if (parameters.body.getPage().getLimit() == null) {
            limit = 10;
            parameters.body.getPage().setLimit(limit);
        } else {
            limit = parameters.body.getPage().getLimit();
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<EventResponse> iterator = new PaginationIterable<EventResponse>(this, "searchEvents", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, limit, args);
        return iterator;
    }

    public ApiResponse<EventsListResponse> searchEventsWithHttpInfo(SearchEventsOptionalParameters parameters) throws ApiException {
        String operationId = "searchEvents";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        EventsListRequest localVarPostBody = parameters.body;
        String localVarPath = "/api/v2/events/search";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.EventsApi.searchEvents", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<EventsListResponse>(){});
    }

    public CompletableFuture<ApiResponse<EventsListResponse>> searchEventsWithHttpInfoAsync(SearchEventsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "searchEvents";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<EventsListResponse>> result = new CompletableFuture<ApiResponse<EventsListResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        EventsListRequest localVarPostBody = parameters.body;
        String localVarPath = "/api/v2/events/search";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("EventsApi.searchEvents", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<EventsListResponse>> result = new CompletableFuture<ApiResponse<EventsListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<EventsListResponse>(){});
    }

    public static class SearchEventsOptionalParameters {
        private EventsListRequest body;

        public SearchEventsOptionalParameters body(EventsListRequest body) {
            this.body = body;
            return this;
        }
    }

    public static class ListEventsOptionalParameters {
        private String filterQuery;
        private String filterFrom;
        private String filterTo;
        private EventsSort sort;
        private String pageCursor;
        private Integer pageLimit;

        public ListEventsOptionalParameters filterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
            return this;
        }

        public ListEventsOptionalParameters filterFrom(String filterFrom) {
            this.filterFrom = filterFrom;
            return this;
        }

        public ListEventsOptionalParameters filterTo(String filterTo) {
            this.filterTo = filterTo;
            return this;
        }

        public ListEventsOptionalParameters sort(EventsSort sort) {
            this.sort = sort;
            return this;
        }

        public ListEventsOptionalParameters pageCursor(String pageCursor) {
            this.pageCursor = pageCursor;
            return this;
        }

        public ListEventsOptionalParameters pageLimit(Integer pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }
    }
}

