/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.HourlyUsageType;
import com.datadog.api.client.v2.model.UsageTimeSeriesObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"org_name", "product_family", "public_id", "timeseries", "usage_type"})
public class UsageAttributesObject {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ORG_NAME = "org_name";
    private String orgName;
    public static final String JSON_PROPERTY_PRODUCT_FAMILY = "product_family";
    private String productFamily;
    public static final String JSON_PROPERTY_PUBLIC_ID = "public_id";
    private String publicId;
    public static final String JSON_PROPERTY_TIMESERIES = "timeseries";
    private List<UsageTimeSeriesObject> timeseries = null;
    public static final String JSON_PROPERTY_USAGE_TYPE = "usage_type";
    private HourlyUsageType usageType;

    public UsageAttributesObject orgName(String orgName) {
        this.orgName = orgName;
        return this;
    }

    @Nullable
    @JsonProperty(value="org_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public UsageAttributesObject productFamily(String productFamily) {
        this.productFamily = productFamily;
        return this;
    }

    @Nullable
    @JsonProperty(value="product_family")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProductFamily() {
        return this.productFamily;
    }

    public void setProductFamily(String productFamily) {
        this.productFamily = productFamily;
    }

    public UsageAttributesObject publicId(String publicId) {
        this.publicId = publicId;
        return this;
    }

    @Nullable
    @JsonProperty(value="public_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public UsageAttributesObject timeseries(List<UsageTimeSeriesObject> timeseries) {
        this.timeseries = timeseries;
        for (UsageTimeSeriesObject item : timeseries) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public UsageAttributesObject addTimeseriesItem(UsageTimeSeriesObject timeseriesItem) {
        if (this.timeseries == null) {
            this.timeseries = new ArrayList<UsageTimeSeriesObject>();
        }
        this.timeseries.add(timeseriesItem);
        this.unparsed |= timeseriesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="timeseries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UsageTimeSeriesObject> getTimeseries() {
        return this.timeseries;
    }

    public void setTimeseries(List<UsageTimeSeriesObject> timeseries) {
        this.timeseries = timeseries;
    }

    public UsageAttributesObject usageType(HourlyUsageType usageType) {
        this.usageType = usageType;
        this.unparsed |= !usageType.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="usage_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HourlyUsageType getUsageType() {
        return this.usageType;
    }

    public void setUsageType(HourlyUsageType usageType) {
        if (!usageType.isValid()) {
            this.unparsed = true;
        }
        this.usageType = usageType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageAttributesObject usageAttributesObject = (UsageAttributesObject)o;
        return Objects.equals(this.orgName, usageAttributesObject.orgName) && Objects.equals(this.productFamily, usageAttributesObject.productFamily) && Objects.equals(this.publicId, usageAttributesObject.publicId) && Objects.equals(this.timeseries, usageAttributesObject.timeseries) && Objects.equals(this.usageType, usageAttributesObject.usageType);
    }

    public int hashCode() {
        return Objects.hash(this.orgName, this.productFamily, this.publicId, this.timeseries, this.usageType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageAttributesObject {\n");
        sb.append("    orgName: ").append(this.toIndentedString(this.orgName)).append("\n");
        sb.append("    productFamily: ").append(this.toIndentedString(this.productFamily)).append("\n");
        sb.append("    publicId: ").append(this.toIndentedString(this.publicId)).append("\n");
        sb.append("    timeseries: ").append(this.toIndentedString(this.timeseries)).append("\n");
        sb.append("    usageType: ").append(this.toIndentedString(this.usageType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

