/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.SecurityMonitoringFilter;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleCase;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleOptions;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleQuery;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleTypeRead;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"cases", "createdAt", "creationAuthorId", "filters", "hasExtendedTitle", "id", "isDefault", "isDeleted", "isEnabled", "message", "name", "options", "queries", "tags", "type", "updateAuthorId", "version"})
public class SecurityMonitoringRuleResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CASES = "cases";
    private List<SecurityMonitoringRuleCase> cases = null;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private Long createdAt;
    public static final String JSON_PROPERTY_CREATION_AUTHOR_ID = "creationAuthorId";
    private Long creationAuthorId;
    public static final String JSON_PROPERTY_FILTERS = "filters";
    private List<SecurityMonitoringFilter> filters = null;
    public static final String JSON_PROPERTY_HAS_EXTENDED_TITLE = "hasExtendedTitle";
    private Boolean hasExtendedTitle;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_IS_DEFAULT = "isDefault";
    private Boolean isDefault;
    public static final String JSON_PROPERTY_IS_DELETED = "isDeleted";
    private Boolean isDeleted;
    public static final String JSON_PROPERTY_IS_ENABLED = "isEnabled";
    private Boolean isEnabled;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private SecurityMonitoringRuleOptions options;
    public static final String JSON_PROPERTY_QUERIES = "queries";
    private List<SecurityMonitoringRuleQuery> queries = null;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private SecurityMonitoringRuleTypeRead type;
    public static final String JSON_PROPERTY_UPDATE_AUTHOR_ID = "updateAuthorId";
    private Long updateAuthorId;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Long version;

    public SecurityMonitoringRuleResponse cases(List<SecurityMonitoringRuleCase> cases) {
        this.cases = cases;
        for (SecurityMonitoringRuleCase item : cases) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SecurityMonitoringRuleResponse addCasesItem(SecurityMonitoringRuleCase casesItem) {
        if (this.cases == null) {
            this.cases = new ArrayList<SecurityMonitoringRuleCase>();
        }
        this.cases.add(casesItem);
        this.unparsed |= casesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="cases")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SecurityMonitoringRuleCase> getCases() {
        return this.cases;
    }

    public void setCases(List<SecurityMonitoringRuleCase> cases) {
        this.cases = cases;
    }

    public SecurityMonitoringRuleResponse createdAt(Long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public SecurityMonitoringRuleResponse creationAuthorId(Long creationAuthorId) {
        this.creationAuthorId = creationAuthorId;
        return this;
    }

    @Nullable
    @JsonProperty(value="creationAuthorId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCreationAuthorId() {
        return this.creationAuthorId;
    }

    public void setCreationAuthorId(Long creationAuthorId) {
        this.creationAuthorId = creationAuthorId;
    }

    public SecurityMonitoringRuleResponse filters(List<SecurityMonitoringFilter> filters) {
        this.filters = filters;
        for (SecurityMonitoringFilter item : filters) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SecurityMonitoringRuleResponse addFiltersItem(SecurityMonitoringFilter filtersItem) {
        if (this.filters == null) {
            this.filters = new ArrayList<SecurityMonitoringFilter>();
        }
        this.filters.add(filtersItem);
        this.unparsed |= filtersItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="filters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SecurityMonitoringFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<SecurityMonitoringFilter> filters) {
        this.filters = filters;
    }

    public SecurityMonitoringRuleResponse hasExtendedTitle(Boolean hasExtendedTitle) {
        this.hasExtendedTitle = hasExtendedTitle;
        return this;
    }

    @Nullable
    @JsonProperty(value="hasExtendedTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasExtendedTitle() {
        return this.hasExtendedTitle;
    }

    public void setHasExtendedTitle(Boolean hasExtendedTitle) {
        this.hasExtendedTitle = hasExtendedTitle;
    }

    public SecurityMonitoringRuleResponse id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public SecurityMonitoringRuleResponse isDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    @Nullable
    @JsonProperty(value="isDefault")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public SecurityMonitoringRuleResponse isDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
        return this;
    }

    @Nullable
    @JsonProperty(value="isDeleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public SecurityMonitoringRuleResponse isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @JsonProperty(value="isEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public SecurityMonitoringRuleResponse message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public SecurityMonitoringRuleResponse name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SecurityMonitoringRuleResponse options(SecurityMonitoringRuleOptions options) {
        this.options = options;
        this.unparsed |= options.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleOptions getOptions() {
        return this.options;
    }

    public void setOptions(SecurityMonitoringRuleOptions options) {
        this.options = options;
    }

    public SecurityMonitoringRuleResponse queries(List<SecurityMonitoringRuleQuery> queries) {
        this.queries = queries;
        for (SecurityMonitoringRuleQuery item : queries) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SecurityMonitoringRuleResponse addQueriesItem(SecurityMonitoringRuleQuery queriesItem) {
        if (this.queries == null) {
            this.queries = new ArrayList<SecurityMonitoringRuleQuery>();
        }
        this.queries.add(queriesItem);
        this.unparsed |= queriesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="queries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SecurityMonitoringRuleQuery> getQueries() {
        return this.queries;
    }

    public void setQueries(List<SecurityMonitoringRuleQuery> queries) {
        this.queries = queries;
    }

    public SecurityMonitoringRuleResponse tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public SecurityMonitoringRuleResponse addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public SecurityMonitoringRuleResponse type(SecurityMonitoringRuleTypeRead type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleTypeRead getType() {
        return this.type;
    }

    public void setType(SecurityMonitoringRuleTypeRead type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public SecurityMonitoringRuleResponse updateAuthorId(Long updateAuthorId) {
        this.updateAuthorId = updateAuthorId;
        return this;
    }

    @Nullable
    @JsonProperty(value="updateAuthorId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getUpdateAuthorId() {
        return this.updateAuthorId;
    }

    public void setUpdateAuthorId(Long updateAuthorId) {
        this.updateAuthorId = updateAuthorId;
    }

    public SecurityMonitoringRuleResponse version(Long version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityMonitoringRuleResponse securityMonitoringRuleResponse = (SecurityMonitoringRuleResponse)o;
        return Objects.equals(this.cases, securityMonitoringRuleResponse.cases) && Objects.equals(this.createdAt, securityMonitoringRuleResponse.createdAt) && Objects.equals(this.creationAuthorId, securityMonitoringRuleResponse.creationAuthorId) && Objects.equals(this.filters, securityMonitoringRuleResponse.filters) && Objects.equals(this.hasExtendedTitle, securityMonitoringRuleResponse.hasExtendedTitle) && Objects.equals(this.id, securityMonitoringRuleResponse.id) && Objects.equals(this.isDefault, securityMonitoringRuleResponse.isDefault) && Objects.equals(this.isDeleted, securityMonitoringRuleResponse.isDeleted) && Objects.equals(this.isEnabled, securityMonitoringRuleResponse.isEnabled) && Objects.equals(this.message, securityMonitoringRuleResponse.message) && Objects.equals(this.name, securityMonitoringRuleResponse.name) && Objects.equals(this.options, securityMonitoringRuleResponse.options) && Objects.equals(this.queries, securityMonitoringRuleResponse.queries) && Objects.equals(this.tags, securityMonitoringRuleResponse.tags) && Objects.equals(this.type, securityMonitoringRuleResponse.type) && Objects.equals(this.updateAuthorId, securityMonitoringRuleResponse.updateAuthorId) && Objects.equals(this.version, securityMonitoringRuleResponse.version);
    }

    public int hashCode() {
        return Objects.hash(this.cases, this.createdAt, this.creationAuthorId, this.filters, this.hasExtendedTitle, this.id, this.isDefault, this.isDeleted, this.isEnabled, this.message, this.name, this.options, this.queries, this.tags, this.type, this.updateAuthorId, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityMonitoringRuleResponse {\n");
        sb.append("    cases: ").append(this.toIndentedString(this.cases)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    creationAuthorId: ").append(this.toIndentedString(this.creationAuthorId)).append("\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        sb.append("    hasExtendedTitle: ").append(this.toIndentedString(this.hasExtendedTitle)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isDefault: ").append(this.toIndentedString(this.isDefault)).append("\n");
        sb.append("    isDeleted: ").append(this.toIndentedString(this.isDeleted)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    queries: ").append(this.toIndentedString(this.queries)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    updateAuthorId: ").append(this.toIndentedString(this.updateAuthorId)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

