/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.SecurityFilterExclusionFilterResponse;
import com.datadog.api.client.v2.model.SecurityFilterFilteredDataType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"exclusion_filters", "filtered_data_type", "is_builtin", "is_enabled", "name", "query", "version"})
public class SecurityFilterAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_EXCLUSION_FILTERS = "exclusion_filters";
    private List<SecurityFilterExclusionFilterResponse> exclusionFilters = null;
    public static final String JSON_PROPERTY_FILTERED_DATA_TYPE = "filtered_data_type";
    private SecurityFilterFilteredDataType filteredDataType;
    public static final String JSON_PROPERTY_IS_BUILTIN = "is_builtin";
    private Boolean isBuiltin;
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Integer version;

    public SecurityFilterAttributes exclusionFilters(List<SecurityFilterExclusionFilterResponse> exclusionFilters) {
        this.exclusionFilters = exclusionFilters;
        for (SecurityFilterExclusionFilterResponse item : exclusionFilters) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SecurityFilterAttributes addExclusionFiltersItem(SecurityFilterExclusionFilterResponse exclusionFiltersItem) {
        if (this.exclusionFilters == null) {
            this.exclusionFilters = new ArrayList<SecurityFilterExclusionFilterResponse>();
        }
        this.exclusionFilters.add(exclusionFiltersItem);
        this.unparsed |= exclusionFiltersItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="exclusion_filters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SecurityFilterExclusionFilterResponse> getExclusionFilters() {
        return this.exclusionFilters;
    }

    public void setExclusionFilters(List<SecurityFilterExclusionFilterResponse> exclusionFilters) {
        this.exclusionFilters = exclusionFilters;
    }

    public SecurityFilterAttributes filteredDataType(SecurityFilterFilteredDataType filteredDataType) {
        this.filteredDataType = filteredDataType;
        this.unparsed |= !filteredDataType.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="filtered_data_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityFilterFilteredDataType getFilteredDataType() {
        return this.filteredDataType;
    }

    public void setFilteredDataType(SecurityFilterFilteredDataType filteredDataType) {
        if (!filteredDataType.isValid()) {
            this.unparsed = true;
        }
        this.filteredDataType = filteredDataType;
    }

    public SecurityFilterAttributes isBuiltin(Boolean isBuiltin) {
        this.isBuiltin = isBuiltin;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_builtin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsBuiltin() {
        return this.isBuiltin;
    }

    public void setIsBuiltin(Boolean isBuiltin) {
        this.isBuiltin = isBuiltin;
    }

    public SecurityFilterAttributes isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public SecurityFilterAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SecurityFilterAttributes query(String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public SecurityFilterAttributes version(Integer version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityFilterAttributes securityFilterAttributes = (SecurityFilterAttributes)o;
        return Objects.equals(this.exclusionFilters, securityFilterAttributes.exclusionFilters) && Objects.equals(this.filteredDataType, securityFilterAttributes.filteredDataType) && Objects.equals(this.isBuiltin, securityFilterAttributes.isBuiltin) && Objects.equals(this.isEnabled, securityFilterAttributes.isEnabled) && Objects.equals(this.name, securityFilterAttributes.name) && Objects.equals(this.query, securityFilterAttributes.query) && Objects.equals(this.version, securityFilterAttributes.version);
    }

    public int hashCode() {
        return Objects.hash(this.exclusionFilters, this.filteredDataType, this.isBuiltin, this.isEnabled, this.name, this.query, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityFilterAttributes {\n");
        sb.append("    exclusionFilters: ").append(this.toIndentedString(this.exclusionFilters)).append("\n");
        sb.append("    filteredDataType: ").append(this.toIndentedString(this.filteredDataType)).append("\n");
        sb.append("    isBuiltin: ").append(this.toIndentedString(this.isBuiltin)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

