/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.IncidentCreateAttributes;
import com.datadog.api.client.v2.model.IncidentCreateRelationships;
import com.datadog.api.client.v2.model.IncidentType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"attributes", "relationships", "type"})
public class IncidentCreateData {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private IncidentCreateAttributes attributes;
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private IncidentCreateRelationships relationships;
    public static final String JSON_PROPERTY_TYPE = "type";
    private IncidentType type = IncidentType.INCIDENTS;

    public IncidentCreateData() {
    }

    @JsonCreator
    public IncidentCreateData(@JsonProperty(required=true, value="attributes") IncidentCreateAttributes attributes, @JsonProperty(required=true, value="type") IncidentType type) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public IncidentCreateData attributes(IncidentCreateAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IncidentCreateAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(IncidentCreateAttributes attributes) {
        this.attributes = attributes;
    }

    public IncidentCreateData relationships(IncidentCreateRelationships relationships) {
        this.relationships = relationships;
        this.unparsed |= relationships.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IncidentCreateRelationships getRelationships() {
        return this.relationships;
    }

    public void setRelationships(IncidentCreateRelationships relationships) {
        this.relationships = relationships;
    }

    public IncidentCreateData type(IncidentType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IncidentType getType() {
        return this.type;
    }

    public void setType(IncidentType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentCreateData incidentCreateData = (IncidentCreateData)o;
        return Objects.equals(this.attributes, incidentCreateData.attributes) && Objects.equals(this.relationships, incidentCreateData.relationships) && Objects.equals(this.type, incidentCreateData.type);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.relationships, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncidentCreateData {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

