/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.DashboardListAddItemsRequest;
import com.datadog.api.client.v2.model.DashboardListAddItemsResponse;
import com.datadog.api.client.v2.model.DashboardListDeleteItemsRequest;
import com.datadog.api.client.v2.model.DashboardListDeleteItemsResponse;
import com.datadog.api.client.v2.model.DashboardListItems;
import com.datadog.api.client.v2.model.DashboardListUpdateItemsRequest;
import com.datadog.api.client.v2.model.DashboardListUpdateItemsResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;

public class DashboardListsApi {
    private ApiClient apiClient;

    public DashboardListsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public DashboardListsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public DashboardListAddItemsResponse createDashboardListItems(Long dashboardListId, DashboardListAddItemsRequest body) throws ApiException {
        return this.createDashboardListItemsWithHttpInfo(dashboardListId, body).getData();
    }

    public CompletableFuture<DashboardListAddItemsResponse> createDashboardListItemsAsync(Long dashboardListId, DashboardListAddItemsRequest body) {
        return this.createDashboardListItemsWithHttpInfoAsync(dashboardListId, body).thenApply(response -> (DashboardListAddItemsResponse)response.getData());
    }

    public ApiResponse<DashboardListAddItemsResponse> createDashboardListItemsWithHttpInfo(Long dashboardListId, DashboardListAddItemsRequest body) throws ApiException {
        DashboardListAddItemsRequest localVarPostBody = body;
        if (dashboardListId == null) {
            throw new ApiException(400, "Missing the required parameter 'dashboardListId' when calling createDashboardListItems");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDashboardListItems");
        }
        String localVarPath = "/api/v2/dashboard/lists/manual/{dashboard_list_id}/dashboards".replaceAll("\\{dashboard_list_id\\}", this.apiClient.escapeString(dashboardListId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DashboardListsApi.createDashboardListItems", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardListAddItemsResponse>(){});
    }

    public CompletableFuture<ApiResponse<DashboardListAddItemsResponse>> createDashboardListItemsWithHttpInfoAsync(Long dashboardListId, DashboardListAddItemsRequest body) {
        Invocation.Builder builder;
        DashboardListAddItemsRequest localVarPostBody = body;
        if (dashboardListId == null) {
            CompletableFuture<ApiResponse<DashboardListAddItemsResponse>> result = new CompletableFuture<ApiResponse<DashboardListAddItemsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'dashboardListId' when calling createDashboardListItems"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<DashboardListAddItemsResponse>> result = new CompletableFuture<ApiResponse<DashboardListAddItemsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createDashboardListItems"));
            return result;
        }
        String localVarPath = "/api/v2/dashboard/lists/manual/{dashboard_list_id}/dashboards".replaceAll("\\{dashboard_list_id\\}", this.apiClient.escapeString(dashboardListId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("DashboardListsApi.createDashboardListItems", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DashboardListAddItemsResponse>> result = new CompletableFuture<ApiResponse<DashboardListAddItemsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardListAddItemsResponse>(){});
    }

    public DashboardListDeleteItemsResponse deleteDashboardListItems(Long dashboardListId, DashboardListDeleteItemsRequest body) throws ApiException {
        return this.deleteDashboardListItemsWithHttpInfo(dashboardListId, body).getData();
    }

    public CompletableFuture<DashboardListDeleteItemsResponse> deleteDashboardListItemsAsync(Long dashboardListId, DashboardListDeleteItemsRequest body) {
        return this.deleteDashboardListItemsWithHttpInfoAsync(dashboardListId, body).thenApply(response -> (DashboardListDeleteItemsResponse)response.getData());
    }

    public ApiResponse<DashboardListDeleteItemsResponse> deleteDashboardListItemsWithHttpInfo(Long dashboardListId, DashboardListDeleteItemsRequest body) throws ApiException {
        DashboardListDeleteItemsRequest localVarPostBody = body;
        if (dashboardListId == null) {
            throw new ApiException(400, "Missing the required parameter 'dashboardListId' when calling deleteDashboardListItems");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteDashboardListItems");
        }
        String localVarPath = "/api/v2/dashboard/lists/manual/{dashboard_list_id}/dashboards".replaceAll("\\{dashboard_list_id\\}", this.apiClient.escapeString(dashboardListId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DashboardListsApi.deleteDashboardListItems", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardListDeleteItemsResponse>(){});
    }

    public CompletableFuture<ApiResponse<DashboardListDeleteItemsResponse>> deleteDashboardListItemsWithHttpInfoAsync(Long dashboardListId, DashboardListDeleteItemsRequest body) {
        Invocation.Builder builder;
        DashboardListDeleteItemsRequest localVarPostBody = body;
        if (dashboardListId == null) {
            CompletableFuture<ApiResponse<DashboardListDeleteItemsResponse>> result = new CompletableFuture<ApiResponse<DashboardListDeleteItemsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'dashboardListId' when calling deleteDashboardListItems"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<DashboardListDeleteItemsResponse>> result = new CompletableFuture<ApiResponse<DashboardListDeleteItemsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling deleteDashboardListItems"));
            return result;
        }
        String localVarPath = "/api/v2/dashboard/lists/manual/{dashboard_list_id}/dashboards".replaceAll("\\{dashboard_list_id\\}", this.apiClient.escapeString(dashboardListId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("DashboardListsApi.deleteDashboardListItems", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DashboardListDeleteItemsResponse>> result = new CompletableFuture<ApiResponse<DashboardListDeleteItemsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardListDeleteItemsResponse>(){});
    }

    public DashboardListItems getDashboardListItems(Long dashboardListId) throws ApiException {
        return this.getDashboardListItemsWithHttpInfo(dashboardListId).getData();
    }

    public CompletableFuture<DashboardListItems> getDashboardListItemsAsync(Long dashboardListId) {
        return this.getDashboardListItemsWithHttpInfoAsync(dashboardListId).thenApply(response -> (DashboardListItems)response.getData());
    }

    public ApiResponse<DashboardListItems> getDashboardListItemsWithHttpInfo(Long dashboardListId) throws ApiException {
        Object localVarPostBody = null;
        if (dashboardListId == null) {
            throw new ApiException(400, "Missing the required parameter 'dashboardListId' when calling getDashboardListItems");
        }
        String localVarPath = "/api/v2/dashboard/lists/manual/{dashboard_list_id}/dashboards".replaceAll("\\{dashboard_list_id\\}", this.apiClient.escapeString(dashboardListId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DashboardListsApi.getDashboardListItems", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardListItems>(){});
    }

    public CompletableFuture<ApiResponse<DashboardListItems>> getDashboardListItemsWithHttpInfoAsync(Long dashboardListId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (dashboardListId == null) {
            CompletableFuture<ApiResponse<DashboardListItems>> result = new CompletableFuture<ApiResponse<DashboardListItems>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'dashboardListId' when calling getDashboardListItems"));
            return result;
        }
        String localVarPath = "/api/v2/dashboard/lists/manual/{dashboard_list_id}/dashboards".replaceAll("\\{dashboard_list_id\\}", this.apiClient.escapeString(dashboardListId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("DashboardListsApi.getDashboardListItems", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DashboardListItems>> result = new CompletableFuture<ApiResponse<DashboardListItems>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardListItems>(){});
    }

    public DashboardListUpdateItemsResponse updateDashboardListItems(Long dashboardListId, DashboardListUpdateItemsRequest body) throws ApiException {
        return this.updateDashboardListItemsWithHttpInfo(dashboardListId, body).getData();
    }

    public CompletableFuture<DashboardListUpdateItemsResponse> updateDashboardListItemsAsync(Long dashboardListId, DashboardListUpdateItemsRequest body) {
        return this.updateDashboardListItemsWithHttpInfoAsync(dashboardListId, body).thenApply(response -> (DashboardListUpdateItemsResponse)response.getData());
    }

    public ApiResponse<DashboardListUpdateItemsResponse> updateDashboardListItemsWithHttpInfo(Long dashboardListId, DashboardListUpdateItemsRequest body) throws ApiException {
        DashboardListUpdateItemsRequest localVarPostBody = body;
        if (dashboardListId == null) {
            throw new ApiException(400, "Missing the required parameter 'dashboardListId' when calling updateDashboardListItems");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateDashboardListItems");
        }
        String localVarPath = "/api/v2/dashboard/lists/manual/{dashboard_list_id}/dashboards".replaceAll("\\{dashboard_list_id\\}", this.apiClient.escapeString(dashboardListId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DashboardListsApi.updateDashboardListItems", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardListUpdateItemsResponse>(){});
    }

    public CompletableFuture<ApiResponse<DashboardListUpdateItemsResponse>> updateDashboardListItemsWithHttpInfoAsync(Long dashboardListId, DashboardListUpdateItemsRequest body) {
        Invocation.Builder builder;
        DashboardListUpdateItemsRequest localVarPostBody = body;
        if (dashboardListId == null) {
            CompletableFuture<ApiResponse<DashboardListUpdateItemsResponse>> result = new CompletableFuture<ApiResponse<DashboardListUpdateItemsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'dashboardListId' when calling updateDashboardListItems"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<DashboardListUpdateItemsResponse>> result = new CompletableFuture<ApiResponse<DashboardListUpdateItemsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateDashboardListItems"));
            return result;
        }
        String localVarPath = "/api/v2/dashboard/lists/manual/{dashboard_list_id}/dashboards".replaceAll("\\{dashboard_list_id\\}", this.apiClient.escapeString(dashboardListId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("DashboardListsApi.updateDashboardListItems", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DashboardListUpdateItemsResponse>> result = new CompletableFuture<ApiResponse<DashboardListUpdateItemsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardListUpdateItemsResponse>(){});
    }
}

