/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.CloudWorkloadSecurityAgentRuleCreateRequest;
import com.datadog.api.client.v2.model.CloudWorkloadSecurityAgentRuleResponse;
import com.datadog.api.client.v2.model.CloudWorkloadSecurityAgentRuleUpdateRequest;
import com.datadog.api.client.v2.model.CloudWorkloadSecurityAgentRulesListResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;

public class CloudWorkloadSecurityApi {
    private ApiClient apiClient;

    public CloudWorkloadSecurityApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public CloudWorkloadSecurityApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CloudWorkloadSecurityAgentRuleResponse createCloudWorkloadSecurityAgentRule(CloudWorkloadSecurityAgentRuleCreateRequest body) throws ApiException {
        return this.createCloudWorkloadSecurityAgentRuleWithHttpInfo(body).getData();
    }

    public CompletableFuture<CloudWorkloadSecurityAgentRuleResponse> createCloudWorkloadSecurityAgentRuleAsync(CloudWorkloadSecurityAgentRuleCreateRequest body) {
        return this.createCloudWorkloadSecurityAgentRuleWithHttpInfoAsync(body).thenApply(response -> (CloudWorkloadSecurityAgentRuleResponse)response.getData());
    }

    public ApiResponse<CloudWorkloadSecurityAgentRuleResponse> createCloudWorkloadSecurityAgentRuleWithHttpInfo(CloudWorkloadSecurityAgentRuleCreateRequest body) throws ApiException {
        CloudWorkloadSecurityAgentRuleCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCloudWorkloadSecurityAgentRule");
        }
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudWorkloadSecurityApi.createCloudWorkloadSecurityAgentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> createCloudWorkloadSecurityAgentRuleWithHttpInfoAsync(CloudWorkloadSecurityAgentRuleCreateRequest body) {
        Invocation.Builder builder;
        CloudWorkloadSecurityAgentRuleCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createCloudWorkloadSecurityAgentRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("CloudWorkloadSecurityApi.createCloudWorkloadSecurityAgentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRuleResponse>(){});
    }

    public void deleteCloudWorkloadSecurityAgentRule(String agentRuleId) throws ApiException {
        this.deleteCloudWorkloadSecurityAgentRuleWithHttpInfo(agentRuleId);
    }

    public CompletableFuture<Void> deleteCloudWorkloadSecurityAgentRuleAsync(String agentRuleId) {
        return this.deleteCloudWorkloadSecurityAgentRuleWithHttpInfoAsync(agentRuleId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteCloudWorkloadSecurityAgentRuleWithHttpInfo(String agentRuleId) throws ApiException {
        Object localVarPostBody = null;
        if (agentRuleId == null) {
            throw new ApiException(400, "Missing the required parameter 'agentRuleId' when calling deleteCloudWorkloadSecurityAgentRule");
        }
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules/{agent_rule_id}".replaceAll("\\{agent_rule_id\\}", this.apiClient.escapeString(agentRuleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudWorkloadSecurityApi.deleteCloudWorkloadSecurityAgentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteCloudWorkloadSecurityAgentRuleWithHttpInfoAsync(String agentRuleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (agentRuleId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'agentRuleId' when calling deleteCloudWorkloadSecurityAgentRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules/{agent_rule_id}".replaceAll("\\{agent_rule_id\\}", this.apiClient.escapeString(agentRuleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("CloudWorkloadSecurityApi.deleteCloudWorkloadSecurityAgentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public File downloadCloudWorkloadPolicyFile() throws ApiException {
        return this.downloadCloudWorkloadPolicyFileWithHttpInfo().getData();
    }

    public CompletableFuture<File> downloadCloudWorkloadPolicyFileAsync() {
        return this.downloadCloudWorkloadPolicyFileWithHttpInfoAsync().thenApply(response -> (File)response.getData());
    }

    public ApiResponse<File> downloadCloudWorkloadPolicyFileWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/security/cloud_workload/policy/download";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudWorkloadSecurityApi.downloadCloudWorkloadPolicyFile", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/yaml", "application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<File>(){});
    }

    public CompletableFuture<ApiResponse<File>> downloadCloudWorkloadPolicyFileWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/security/cloud_workload/policy/download";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("CloudWorkloadSecurityApi.downloadCloudWorkloadPolicyFile", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/yaml", "application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<File>> result = new CompletableFuture<ApiResponse<File>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<File>(){});
    }

    public CloudWorkloadSecurityAgentRuleResponse getCloudWorkloadSecurityAgentRule(String agentRuleId) throws ApiException {
        return this.getCloudWorkloadSecurityAgentRuleWithHttpInfo(agentRuleId).getData();
    }

    public CompletableFuture<CloudWorkloadSecurityAgentRuleResponse> getCloudWorkloadSecurityAgentRuleAsync(String agentRuleId) {
        return this.getCloudWorkloadSecurityAgentRuleWithHttpInfoAsync(agentRuleId).thenApply(response -> (CloudWorkloadSecurityAgentRuleResponse)response.getData());
    }

    public ApiResponse<CloudWorkloadSecurityAgentRuleResponse> getCloudWorkloadSecurityAgentRuleWithHttpInfo(String agentRuleId) throws ApiException {
        Object localVarPostBody = null;
        if (agentRuleId == null) {
            throw new ApiException(400, "Missing the required parameter 'agentRuleId' when calling getCloudWorkloadSecurityAgentRule");
        }
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules/{agent_rule_id}".replaceAll("\\{agent_rule_id\\}", this.apiClient.escapeString(agentRuleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudWorkloadSecurityApi.getCloudWorkloadSecurityAgentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> getCloudWorkloadSecurityAgentRuleWithHttpInfoAsync(String agentRuleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (agentRuleId == null) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'agentRuleId' when calling getCloudWorkloadSecurityAgentRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules/{agent_rule_id}".replaceAll("\\{agent_rule_id\\}", this.apiClient.escapeString(agentRuleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("CloudWorkloadSecurityApi.getCloudWorkloadSecurityAgentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRuleResponse>(){});
    }

    public CloudWorkloadSecurityAgentRulesListResponse listCloudWorkloadSecurityAgentRules() throws ApiException {
        return this.listCloudWorkloadSecurityAgentRulesWithHttpInfo().getData();
    }

    public CompletableFuture<CloudWorkloadSecurityAgentRulesListResponse> listCloudWorkloadSecurityAgentRulesAsync() {
        return this.listCloudWorkloadSecurityAgentRulesWithHttpInfoAsync().thenApply(response -> (CloudWorkloadSecurityAgentRulesListResponse)response.getData());
    }

    public ApiResponse<CloudWorkloadSecurityAgentRulesListResponse> listCloudWorkloadSecurityAgentRulesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudWorkloadSecurityApi.listCloudWorkloadSecurityAgentRules", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRulesListResponse>(){});
    }

    public CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRulesListResponse>> listCloudWorkloadSecurityAgentRulesWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("CloudWorkloadSecurityApi.listCloudWorkloadSecurityAgentRules", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRulesListResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRulesListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRulesListResponse>(){});
    }

    public CloudWorkloadSecurityAgentRuleResponse updateCloudWorkloadSecurityAgentRule(String agentRuleId, CloudWorkloadSecurityAgentRuleUpdateRequest body) throws ApiException {
        return this.updateCloudWorkloadSecurityAgentRuleWithHttpInfo(agentRuleId, body).getData();
    }

    public CompletableFuture<CloudWorkloadSecurityAgentRuleResponse> updateCloudWorkloadSecurityAgentRuleAsync(String agentRuleId, CloudWorkloadSecurityAgentRuleUpdateRequest body) {
        return this.updateCloudWorkloadSecurityAgentRuleWithHttpInfoAsync(agentRuleId, body).thenApply(response -> (CloudWorkloadSecurityAgentRuleResponse)response.getData());
    }

    public ApiResponse<CloudWorkloadSecurityAgentRuleResponse> updateCloudWorkloadSecurityAgentRuleWithHttpInfo(String agentRuleId, CloudWorkloadSecurityAgentRuleUpdateRequest body) throws ApiException {
        CloudWorkloadSecurityAgentRuleUpdateRequest localVarPostBody = body;
        if (agentRuleId == null) {
            throw new ApiException(400, "Missing the required parameter 'agentRuleId' when calling updateCloudWorkloadSecurityAgentRule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCloudWorkloadSecurityAgentRule");
        }
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules/{agent_rule_id}".replaceAll("\\{agent_rule_id\\}", this.apiClient.escapeString(agentRuleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudWorkloadSecurityApi.updateCloudWorkloadSecurityAgentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> updateCloudWorkloadSecurityAgentRuleWithHttpInfoAsync(String agentRuleId, CloudWorkloadSecurityAgentRuleUpdateRequest body) {
        Invocation.Builder builder;
        CloudWorkloadSecurityAgentRuleUpdateRequest localVarPostBody = body;
        if (agentRuleId == null) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'agentRuleId' when calling updateCloudWorkloadSecurityAgentRule"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateCloudWorkloadSecurityAgentRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules/{agent_rule_id}".replaceAll("\\{agent_rule_id\\}", this.apiClient.escapeString(agentRuleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("CloudWorkloadSecurityApi.updateCloudWorkloadSecurityAgentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRuleResponse>(){});
    }
}

