/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.JsonTimeSerializer;
import com.datadog.api.client.v1.model.LogsRetentionSumUsage;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"date", "usage"})
public class LogsByRetentionMonthlyUsage {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATE = "date";
    @JsonSerialize(using=JsonTimeSerializer.class)
    private OffsetDateTime date;
    public static final String JSON_PROPERTY_USAGE = "usage";
    private List<LogsRetentionSumUsage> usage = null;

    public LogsByRetentionMonthlyUsage date(OffsetDateTime date) {
        this.date = date;
        return this;
    }

    @Nullable
    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDate() {
        return this.date;
    }

    public void setDate(OffsetDateTime date) {
        this.date = date;
    }

    public LogsByRetentionMonthlyUsage usage(List<LogsRetentionSumUsage> usage) {
        this.usage = usage;
        for (LogsRetentionSumUsage item : usage) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public LogsByRetentionMonthlyUsage addUsageItem(LogsRetentionSumUsage usageItem) {
        if (this.usage == null) {
            this.usage = new ArrayList<LogsRetentionSumUsage>();
        }
        this.usage.add(usageItem);
        this.unparsed |= usageItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LogsRetentionSumUsage> getUsage() {
        return this.usage;
    }

    public void setUsage(List<LogsRetentionSumUsage> usage) {
        this.usage = usage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsByRetentionMonthlyUsage logsByRetentionMonthlyUsage = (LogsByRetentionMonthlyUsage)o;
        return Objects.equals(this.date, logsByRetentionMonthlyUsage.date) && Objects.equals(this.usage, logsByRetentionMonthlyUsage.usage);
    }

    public int hashCode() {
        return Objects.hash(this.date, this.usage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsByRetentionMonthlyUsage {\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    usage: ").append(this.toIndentedString(this.usage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

