/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.GroupWidgetDefinitionType;
import com.datadog.api.client.v1.model.Widget;
import com.datadog.api.client.v1.model.WidgetLayoutType;
import com.datadog.api.client.v1.model.WidgetTextAlign;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"background_color", "banner_img", "layout_type", "show_title", "title", "title_align", "type", "widgets"})
public class GroupWidgetDefinition {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_BACKGROUND_COLOR = "background_color";
    private String backgroundColor;
    public static final String JSON_PROPERTY_BANNER_IMG = "banner_img";
    private String bannerImg;
    public static final String JSON_PROPERTY_LAYOUT_TYPE = "layout_type";
    private WidgetLayoutType layoutType;
    public static final String JSON_PROPERTY_SHOW_TITLE = "show_title";
    private Boolean showTitle = true;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TYPE = "type";
    private GroupWidgetDefinitionType type = GroupWidgetDefinitionType.GROUP;
    public static final String JSON_PROPERTY_WIDGETS = "widgets";
    private List<Widget> widgets = new ArrayList<Widget>();

    public GroupWidgetDefinition() {
    }

    @JsonCreator
    public GroupWidgetDefinition(@JsonProperty(required=true, value="layout_type") WidgetLayoutType layoutType, @JsonProperty(required=true, value="type") GroupWidgetDefinitionType type, @JsonProperty(required=true, value="widgets") List<Widget> widgets) {
        this.layoutType = layoutType;
        this.unparsed |= !layoutType.isValid();
        this.type = type;
        this.unparsed |= !type.isValid();
        this.widgets = widgets;
    }

    public GroupWidgetDefinition backgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @Nullable
    @JsonProperty(value="background_color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public GroupWidgetDefinition bannerImg(String bannerImg) {
        this.bannerImg = bannerImg;
        return this;
    }

    @Nullable
    @JsonProperty(value="banner_img")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBannerImg() {
        return this.bannerImg;
    }

    public void setBannerImg(String bannerImg) {
        this.bannerImg = bannerImg;
    }

    public GroupWidgetDefinition layoutType(WidgetLayoutType layoutType) {
        this.layoutType = layoutType;
        this.unparsed |= !layoutType.isValid();
        return this;
    }

    @JsonProperty(value="layout_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public WidgetLayoutType getLayoutType() {
        return this.layoutType;
    }

    public void setLayoutType(WidgetLayoutType layoutType) {
        if (!layoutType.isValid()) {
            this.unparsed = true;
        }
        this.layoutType = layoutType;
    }

    public GroupWidgetDefinition showTitle(Boolean showTitle) {
        this.showTitle = showTitle;
        return this;
    }

    @Nullable
    @JsonProperty(value="show_title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowTitle() {
        return this.showTitle;
    }

    public void setShowTitle(Boolean showTitle) {
        this.showTitle = showTitle;
    }

    public GroupWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public GroupWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        this.unparsed |= !titleAlign.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        if (!titleAlign.isValid()) {
            this.unparsed = true;
        }
        this.titleAlign = titleAlign;
    }

    public GroupWidgetDefinition type(GroupWidgetDefinitionType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GroupWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(GroupWidgetDefinitionType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public GroupWidgetDefinition widgets(List<Widget> widgets) {
        this.widgets = widgets;
        for (Widget item : widgets) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public GroupWidgetDefinition addWidgetsItem(Widget widgetsItem) {
        this.widgets.add(widgetsItem);
        this.unparsed |= widgetsItem.unparsed;
        return this;
    }

    @JsonProperty(value="widgets")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public void setWidgets(List<Widget> widgets) {
        this.widgets = widgets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupWidgetDefinition groupWidgetDefinition = (GroupWidgetDefinition)o;
        return Objects.equals(this.backgroundColor, groupWidgetDefinition.backgroundColor) && Objects.equals(this.bannerImg, groupWidgetDefinition.bannerImg) && Objects.equals(this.layoutType, groupWidgetDefinition.layoutType) && Objects.equals(this.showTitle, groupWidgetDefinition.showTitle) && Objects.equals(this.title, groupWidgetDefinition.title) && Objects.equals(this.titleAlign, groupWidgetDefinition.titleAlign) && Objects.equals(this.type, groupWidgetDefinition.type) && Objects.equals(this.widgets, groupWidgetDefinition.widgets);
    }

    public int hashCode() {
        return Objects.hash(this.backgroundColor, this.bannerImg, this.layoutType, this.showTitle, this.title, this.titleAlign, this.type, this.widgets);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupWidgetDefinition {\n");
        sb.append("    backgroundColor: ").append(this.toIndentedString(this.backgroundColor)).append("\n");
        sb.append("    bannerImg: ").append(this.toIndentedString(this.bannerImg)).append("\n");
        sb.append("    layoutType: ").append(this.toIndentedString(this.layoutType)).append("\n");
        sb.append("    showTitle: ").append(this.toIndentedString(this.showTitle)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString(this.titleAlign)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    widgets: ").append(this.toIndentedString(this.widgets)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

