/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.AWSNamespace;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"account_id", "namespace", "tag_filter_str"})
public class AWSTagFilterCreateRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ACCOUNT_ID = "account_id";
    private String accountId;
    public static final String JSON_PROPERTY_NAMESPACE = "namespace";
    private AWSNamespace namespace;
    public static final String JSON_PROPERTY_TAG_FILTER_STR = "tag_filter_str";
    private String tagFilterStr;

    public AWSTagFilterCreateRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @JsonProperty(value="account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public AWSTagFilterCreateRequest namespace(AWSNamespace namespace) {
        this.namespace = namespace;
        this.unparsed |= !namespace.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="namespace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AWSNamespace getNamespace() {
        return this.namespace;
    }

    public void setNamespace(AWSNamespace namespace) {
        if (!namespace.isValid()) {
            this.unparsed = true;
        }
        this.namespace = namespace;
    }

    public AWSTagFilterCreateRequest tagFilterStr(String tagFilterStr) {
        this.tagFilterStr = tagFilterStr;
        return this;
    }

    @Nullable
    @JsonProperty(value="tag_filter_str")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTagFilterStr() {
        return this.tagFilterStr;
    }

    public void setTagFilterStr(String tagFilterStr) {
        this.tagFilterStr = tagFilterStr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSTagFilterCreateRequest awsTagFilterCreateRequest = (AWSTagFilterCreateRequest)o;
        return Objects.equals(this.accountId, awsTagFilterCreateRequest.accountId) && Objects.equals(this.namespace, awsTagFilterCreateRequest.namespace) && Objects.equals(this.tagFilterStr, awsTagFilterCreateRequest.tagFilterStr);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.namespace, this.tagFilterStr);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AWSTagFilterCreateRequest {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    tagFilterStr: ").append(this.toIndentedString(this.tagFilterStr)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

