/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.SecurityMonitoringFilter;
import com.datadog.api.v2.client.model.SecurityMonitoringRuleCaseCreate;
import com.datadog.api.v2.client.model.SecurityMonitoringRuleOptions;
import com.datadog.api.v2.client.model.SecurityMonitoringRuleQueryCreate;
import com.datadog.api.v2.client.model.SecurityMonitoringRuleTypeCreate;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"cases", "filters", "hasExtendedTitle", "isEnabled", "message", "name", "options", "queries", "tags", "type"})
public class SecurityMonitoringRuleCreatePayload {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CASES = "cases";
    private List<SecurityMonitoringRuleCaseCreate> cases = new ArrayList<SecurityMonitoringRuleCaseCreate>();
    public static final String JSON_PROPERTY_FILTERS = "filters";
    private List<SecurityMonitoringFilter> filters = null;
    public static final String JSON_PROPERTY_HAS_EXTENDED_TITLE = "hasExtendedTitle";
    private Boolean hasExtendedTitle;
    public static final String JSON_PROPERTY_IS_ENABLED = "isEnabled";
    private Boolean isEnabled;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private SecurityMonitoringRuleOptions options;
    public static final String JSON_PROPERTY_QUERIES = "queries";
    private List<SecurityMonitoringRuleQueryCreate> queries = new ArrayList<SecurityMonitoringRuleQueryCreate>();
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private SecurityMonitoringRuleTypeCreate type;

    public SecurityMonitoringRuleCreatePayload() {
    }

    @JsonCreator
    public SecurityMonitoringRuleCreatePayload(@JsonProperty(required=true, value="cases") List<SecurityMonitoringRuleCaseCreate> cases, @JsonProperty(required=true, value="isEnabled") Boolean isEnabled, @JsonProperty(required=true, value="message") String message, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="options") SecurityMonitoringRuleOptions options, @JsonProperty(required=true, value="queries") List<SecurityMonitoringRuleQueryCreate> queries) {
        this.cases = cases;
        this.isEnabled = isEnabled;
        this.message = message;
        this.name = name;
        this.options = options;
        this.unparsed |= options.unparsed;
        this.queries = queries;
    }

    public SecurityMonitoringRuleCreatePayload cases(List<SecurityMonitoringRuleCaseCreate> cases) {
        this.cases = cases;
        for (SecurityMonitoringRuleCaseCreate item : cases) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SecurityMonitoringRuleCreatePayload addCasesItem(SecurityMonitoringRuleCaseCreate casesItem) {
        this.cases.add(casesItem);
        this.unparsed |= casesItem.unparsed;
        return this;
    }

    @JsonProperty(value="cases")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SecurityMonitoringRuleCaseCreate> getCases() {
        return this.cases;
    }

    public void setCases(List<SecurityMonitoringRuleCaseCreate> cases) {
        this.cases = cases;
    }

    public SecurityMonitoringRuleCreatePayload filters(List<SecurityMonitoringFilter> filters) {
        this.filters = filters;
        for (SecurityMonitoringFilter item : filters) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SecurityMonitoringRuleCreatePayload addFiltersItem(SecurityMonitoringFilter filtersItem) {
        if (this.filters == null) {
            this.filters = new ArrayList<SecurityMonitoringFilter>();
        }
        this.filters.add(filtersItem);
        this.unparsed |= filtersItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="filters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SecurityMonitoringFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<SecurityMonitoringFilter> filters) {
        this.filters = filters;
    }

    public SecurityMonitoringRuleCreatePayload hasExtendedTitle(Boolean hasExtendedTitle) {
        this.hasExtendedTitle = hasExtendedTitle;
        return this;
    }

    @Nullable
    @JsonProperty(value="hasExtendedTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasExtendedTitle() {
        return this.hasExtendedTitle;
    }

    public void setHasExtendedTitle(Boolean hasExtendedTitle) {
        this.hasExtendedTitle = hasExtendedTitle;
    }

    public SecurityMonitoringRuleCreatePayload isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @JsonProperty(value="isEnabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public SecurityMonitoringRuleCreatePayload message(String message) {
        this.message = message;
        return this;
    }

    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public SecurityMonitoringRuleCreatePayload name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SecurityMonitoringRuleCreatePayload options(SecurityMonitoringRuleOptions options) {
        this.options = options;
        this.unparsed |= options.unparsed;
        return this;
    }

    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SecurityMonitoringRuleOptions getOptions() {
        return this.options;
    }

    public void setOptions(SecurityMonitoringRuleOptions options) {
        this.options = options;
    }

    public SecurityMonitoringRuleCreatePayload queries(List<SecurityMonitoringRuleQueryCreate> queries) {
        this.queries = queries;
        for (SecurityMonitoringRuleQueryCreate item : queries) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SecurityMonitoringRuleCreatePayload addQueriesItem(SecurityMonitoringRuleQueryCreate queriesItem) {
        this.queries.add(queriesItem);
        this.unparsed |= queriesItem.unparsed;
        return this;
    }

    @JsonProperty(value="queries")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SecurityMonitoringRuleQueryCreate> getQueries() {
        return this.queries;
    }

    public void setQueries(List<SecurityMonitoringRuleQueryCreate> queries) {
        this.queries = queries;
    }

    public SecurityMonitoringRuleCreatePayload tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public SecurityMonitoringRuleCreatePayload addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public SecurityMonitoringRuleCreatePayload type(SecurityMonitoringRuleTypeCreate type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleTypeCreate getType() {
        return this.type;
    }

    public void setType(SecurityMonitoringRuleTypeCreate type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityMonitoringRuleCreatePayload securityMonitoringRuleCreatePayload = (SecurityMonitoringRuleCreatePayload)o;
        return Objects.equals(this.cases, securityMonitoringRuleCreatePayload.cases) && Objects.equals(this.filters, securityMonitoringRuleCreatePayload.filters) && Objects.equals(this.hasExtendedTitle, securityMonitoringRuleCreatePayload.hasExtendedTitle) && Objects.equals(this.isEnabled, securityMonitoringRuleCreatePayload.isEnabled) && Objects.equals(this.message, securityMonitoringRuleCreatePayload.message) && Objects.equals(this.name, securityMonitoringRuleCreatePayload.name) && Objects.equals(this.options, securityMonitoringRuleCreatePayload.options) && Objects.equals(this.queries, securityMonitoringRuleCreatePayload.queries) && Objects.equals(this.tags, securityMonitoringRuleCreatePayload.tags) && Objects.equals(this.type, securityMonitoringRuleCreatePayload.type);
    }

    public int hashCode() {
        return Objects.hash(this.cases, this.filters, this.hasExtendedTitle, this.isEnabled, this.message, this.name, this.options, this.queries, this.tags, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityMonitoringRuleCreatePayload {\n");
        sb.append("    cases: ").append(this.toIndentedString(this.cases)).append("\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        sb.append("    hasExtendedTitle: ").append(this.toIndentedString(this.hasExtendedTitle)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    queries: ").append(this.toIndentedString(this.queries)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

