/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=IncidentFieldAttributesValueTypeSerializer.class)
public class IncidentFieldAttributesValueType {
    public static final IncidentFieldAttributesValueType MULTISELECT = new IncidentFieldAttributesValueType("multiselect");
    public static final IncidentFieldAttributesValueType TEXTARRAY = new IncidentFieldAttributesValueType("textarray");
    public static final IncidentFieldAttributesValueType METRICTAG = new IncidentFieldAttributesValueType("metrictag");
    public static final IncidentFieldAttributesValueType AUTOCOMPLETE = new IncidentFieldAttributesValueType("autocomplete");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("multiselect", "textarray", "metrictag", "autocomplete"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    IncidentFieldAttributesValueType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((IncidentFieldAttributesValueType)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static IncidentFieldAttributesValueType fromValue(String value) {
        return new IncidentFieldAttributesValueType(value);
    }

    public static class IncidentFieldAttributesValueTypeSerializer
    extends StdSerializer<IncidentFieldAttributesValueType> {
        public IncidentFieldAttributesValueTypeSerializer(Class<IncidentFieldAttributesValueType> t) {
            super(t);
        }

        public IncidentFieldAttributesValueTypeSerializer() {
            this(null);
        }

        public void serialize(IncidentFieldAttributesValueType value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

