/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.SAMLAssertionAttributeAttributes;
import com.datadog.api.v2.client.model.SAMLAssertionAttributesType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="SAML assertion attribute.")
@JsonPropertyOrder(value={"attributes", "id", "type"})
public class SAMLAssertionAttribute {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private SAMLAssertionAttributeAttributes attributes;
    public static final String JSON_PROPERTY_ID = "id";
    private Integer id;
    public static final String JSON_PROPERTY_TYPE = "type";
    private SAMLAssertionAttributesType type = SAMLAssertionAttributesType.SAML_ASSERTION_ATTRIBUTES;

    public SAMLAssertionAttribute() {
    }

    @JsonCreator
    public SAMLAssertionAttribute(@JsonProperty(required=true, value="id") Integer id, @JsonProperty(required=true, value="type") SAMLAssertionAttributesType type) {
        this.id = id;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public SAMLAssertionAttribute attributes(SAMLAssertionAttributeAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SAMLAssertionAttributeAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(SAMLAssertionAttributeAttributes attributes) {
        this.attributes = attributes;
    }

    public SAMLAssertionAttribute id(Integer id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="0", required=true, value="The ID of the SAML assertion attribute.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public SAMLAssertionAttribute type(SAMLAssertionAttributesType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SAMLAssertionAttributesType getType() {
        return this.type;
    }

    public void setType(SAMLAssertionAttributesType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAMLAssertionAttribute saMLAssertionAttribute = (SAMLAssertionAttribute)o;
        return Objects.equals(this.attributes, saMLAssertionAttribute.attributes) && Objects.equals(this.id, saMLAssertionAttribute.id) && Objects.equals(this.type, saMLAssertionAttribute.type);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.id, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SAMLAssertionAttribute {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

