/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Optional parameters for bulk creating metric tag configurations.")
@JsonPropertyOrder(value={"emails", "tags"})
public class MetricBulkTagConfigCreateAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_EMAILS = "emails";
    private List<String> emails = null;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;

    public MetricBulkTagConfigCreateAttributes emails(List<String> emails) {
        this.emails = emails;
        return this;
    }

    public MetricBulkTagConfigCreateAttributes addEmailsItem(String emailsItem) {
        if (this.emails == null) {
            this.emails = new ArrayList<String>();
        }
        this.emails.add(emailsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"sue@example.com\",\"bob@example.com\"]", value="A list of account emails to notify when the configuration is applied.")
    @JsonProperty(value="emails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getEmails() {
        return this.emails;
    }

    public void setEmails(List<String> emails) {
        this.emails = emails;
    }

    public MetricBulkTagConfigCreateAttributes tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public MetricBulkTagConfigCreateAttributes addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"host\",\"pod_name\",\"is_shadow\"]", value="A list of tag names to apply to the configuration.")
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricBulkTagConfigCreateAttributes metricBulkTagConfigCreateAttributes = (MetricBulkTagConfigCreateAttributes)o;
        return Objects.equals(this.emails, metricBulkTagConfigCreateAttributes.emails) && Objects.equals(this.tags, metricBulkTagConfigCreateAttributes.tags);
    }

    public int hashCode() {
        return Objects.hash(this.emails, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricBulkTagConfigCreateAttributes {\n");
        sb.append("    emails: ").append(this.toIndentedString(this.emails)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

