/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.APIKeyCreateRequest;
import com.datadog.api.v2.client.model.APIKeyResponse;
import com.datadog.api.v2.client.model.APIKeyUpdateRequest;
import com.datadog.api.v2.client.model.APIKeysResponse;
import com.datadog.api.v2.client.model.APIKeysSort;
import com.datadog.api.v2.client.model.ApplicationKeyCreateRequest;
import com.datadog.api.v2.client.model.ApplicationKeyResponse;
import com.datadog.api.v2.client.model.ApplicationKeyUpdateRequest;
import com.datadog.api.v2.client.model.ApplicationKeysSort;
import com.datadog.api.v2.client.model.ListApplicationKeysResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;

public class KeyManagementApi {
    private ApiClient apiClient;

    public KeyManagementApi() {
        this(Configuration.getDefaultApiClient());
    }

    public KeyManagementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public APIKeyResponse createAPIKey(APIKeyCreateRequest body) throws ApiException {
        return this.createAPIKeyWithHttpInfo(body).getData();
    }

    public CompletableFuture<APIKeyResponse> createAPIKeyAsync(APIKeyCreateRequest body) {
        return this.createAPIKeyWithHttpInfoAsync(body).thenApply(response -> (APIKeyResponse)response.getData());
    }

    public ApiResponse<APIKeyResponse> createAPIKeyWithHttpInfo(APIKeyCreateRequest body) throws ApiException {
        APIKeyCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createAPIKey");
        }
        String localVarPath = "/api/v2/api_keys";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createAPIKey");
        Invocation.Builder builder = this.apiClient.createBuilder("KeyManagementApi.createAPIKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<APIKeyResponse>(){});
    }

    public CompletableFuture<ApiResponse<APIKeyResponse>> createAPIKeyWithHttpInfoAsync(APIKeyCreateRequest body) {
        Invocation.Builder builder;
        APIKeyCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<APIKeyResponse>> result = new CompletableFuture<ApiResponse<APIKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createAPIKey"));
            return result;
        }
        String localVarPath = "/api/v2/api_keys";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createAPIKey");
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.createAPIKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<APIKeyResponse>> result = new CompletableFuture<ApiResponse<APIKeyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<APIKeyResponse>(){});
    }

    public ApplicationKeyResponse createCurrentUserApplicationKey(ApplicationKeyCreateRequest body) throws ApiException {
        return this.createCurrentUserApplicationKeyWithHttpInfo(body).getData();
    }

    public CompletableFuture<ApplicationKeyResponse> createCurrentUserApplicationKeyAsync(ApplicationKeyCreateRequest body) {
        return this.createCurrentUserApplicationKeyWithHttpInfoAsync(body).thenApply(response -> (ApplicationKeyResponse)response.getData());
    }

    public ApiResponse<ApplicationKeyResponse> createCurrentUserApplicationKeyWithHttpInfo(ApplicationKeyCreateRequest body) throws ApiException {
        ApplicationKeyCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCurrentUserApplicationKey");
        }
        String localVarPath = "/api/v2/current_user/application_keys";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createCurrentUserApplicationKey");
        Invocation.Builder builder = this.apiClient.createBuilder("KeyManagementApi.createCurrentUserApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationKeyResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApplicationKeyResponse>> createCurrentUserApplicationKeyWithHttpInfoAsync(ApplicationKeyCreateRequest body) {
        Invocation.Builder builder;
        ApplicationKeyCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createCurrentUserApplicationKey"));
            return result;
        }
        String localVarPath = "/api/v2/current_user/application_keys";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createCurrentUserApplicationKey");
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.createCurrentUserApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationKeyResponse>(){});
    }

    public void deleteAPIKey(String apiKeyId) throws ApiException {
        this.deleteAPIKeyWithHttpInfo(apiKeyId);
    }

    public CompletableFuture<Void> deleteAPIKeyAsync(String apiKeyId) {
        return this.deleteAPIKeyWithHttpInfoAsync(apiKeyId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteAPIKeyWithHttpInfo(String apiKeyId) throws ApiException {
        Object localVarPostBody = null;
        if (apiKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'apiKeyId' when calling deleteAPIKey");
        }
        String localVarPath = "/api/v2/api_keys/{api_key_id}".replaceAll("\\{api_key_id\\}", this.apiClient.escapeString(apiKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteAPIKey");
        Invocation.Builder builder = this.apiClient.createBuilder("KeyManagementApi.deleteAPIKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteAPIKeyWithHttpInfoAsync(String apiKeyId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (apiKeyId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'apiKeyId' when calling deleteAPIKey"));
            return result;
        }
        String localVarPath = "/api/v2/api_keys/{api_key_id}".replaceAll("\\{api_key_id\\}", this.apiClient.escapeString(apiKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteAPIKey");
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.deleteAPIKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteApplicationKey(String appKeyId) throws ApiException {
        this.deleteApplicationKeyWithHttpInfo(appKeyId);
    }

    public CompletableFuture<Void> deleteApplicationKeyAsync(String appKeyId) {
        return this.deleteApplicationKeyWithHttpInfoAsync(appKeyId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteApplicationKeyWithHttpInfo(String appKeyId) throws ApiException {
        Object localVarPostBody = null;
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling deleteApplicationKey");
        }
        String localVarPath = "/api/v2/application_keys/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteApplicationKey");
        Invocation.Builder builder = this.apiClient.createBuilder("KeyManagementApi.deleteApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteApplicationKeyWithHttpInfoAsync(String appKeyId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (appKeyId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appKeyId' when calling deleteApplicationKey"));
            return result;
        }
        String localVarPath = "/api/v2/application_keys/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteApplicationKey");
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.deleteApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteCurrentUserApplicationKey(String appKeyId) throws ApiException {
        this.deleteCurrentUserApplicationKeyWithHttpInfo(appKeyId);
    }

    public CompletableFuture<Void> deleteCurrentUserApplicationKeyAsync(String appKeyId) {
        return this.deleteCurrentUserApplicationKeyWithHttpInfoAsync(appKeyId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteCurrentUserApplicationKeyWithHttpInfo(String appKeyId) throws ApiException {
        Object localVarPostBody = null;
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling deleteCurrentUserApplicationKey");
        }
        String localVarPath = "/api/v2/current_user/application_keys/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteCurrentUserApplicationKey");
        Invocation.Builder builder = this.apiClient.createBuilder("KeyManagementApi.deleteCurrentUserApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteCurrentUserApplicationKeyWithHttpInfoAsync(String appKeyId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (appKeyId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appKeyId' when calling deleteCurrentUserApplicationKey"));
            return result;
        }
        String localVarPath = "/api/v2/current_user/application_keys/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteCurrentUserApplicationKey");
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.deleteCurrentUserApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public APIKeyResponse getAPIKey(String apiKeyId) throws ApiException {
        return this.getAPIKeyWithHttpInfo(apiKeyId, new GetAPIKeyOptionalParameters()).getData();
    }

    public CompletableFuture<APIKeyResponse> getAPIKeyAsync(String apiKeyId) {
        return this.getAPIKeyWithHttpInfoAsync(apiKeyId, new GetAPIKeyOptionalParameters()).thenApply(response -> (APIKeyResponse)response.getData());
    }

    public APIKeyResponse getAPIKey(String apiKeyId, GetAPIKeyOptionalParameters parameters) throws ApiException {
        return this.getAPIKeyWithHttpInfo(apiKeyId, parameters).getData();
    }

    public CompletableFuture<APIKeyResponse> getAPIKeyAsync(String apiKeyId, GetAPIKeyOptionalParameters parameters) {
        return this.getAPIKeyWithHttpInfoAsync(apiKeyId, parameters).thenApply(response -> (APIKeyResponse)response.getData());
    }

    public ApiResponse<APIKeyResponse> getAPIKeyWithHttpInfo(String apiKeyId, GetAPIKeyOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (apiKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'apiKeyId' when calling getAPIKey");
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/api_keys/{api_key_id}".replaceAll("\\{api_key_id\\}", this.apiClient.escapeString(apiKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarHeaderParams.put("DD-OPERATION-ID", "getAPIKey");
        Invocation.Builder builder = this.apiClient.createBuilder("KeyManagementApi.getAPIKey", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<APIKeyResponse>(){});
    }

    public CompletableFuture<ApiResponse<APIKeyResponse>> getAPIKeyWithHttpInfoAsync(String apiKeyId, GetAPIKeyOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (apiKeyId == null) {
            CompletableFuture<ApiResponse<APIKeyResponse>> result = new CompletableFuture<ApiResponse<APIKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'apiKeyId' when calling getAPIKey"));
            return result;
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/api_keys/{api_key_id}".replaceAll("\\{api_key_id\\}", this.apiClient.escapeString(apiKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarHeaderParams.put("DD-OPERATION-ID", "getAPIKey");
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.getAPIKey", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<APIKeyResponse>> result = new CompletableFuture<ApiResponse<APIKeyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<APIKeyResponse>(){});
    }

    public ApplicationKeyResponse getApplicationKey(String appKeyId) throws ApiException {
        return this.getApplicationKeyWithHttpInfo(appKeyId, new GetApplicationKeyOptionalParameters()).getData();
    }

    public CompletableFuture<ApplicationKeyResponse> getApplicationKeyAsync(String appKeyId) {
        return this.getApplicationKeyWithHttpInfoAsync(appKeyId, new GetApplicationKeyOptionalParameters()).thenApply(response -> (ApplicationKeyResponse)response.getData());
    }

    public ApplicationKeyResponse getApplicationKey(String appKeyId, GetApplicationKeyOptionalParameters parameters) throws ApiException {
        return this.getApplicationKeyWithHttpInfo(appKeyId, parameters).getData();
    }

    public CompletableFuture<ApplicationKeyResponse> getApplicationKeyAsync(String appKeyId, GetApplicationKeyOptionalParameters parameters) {
        return this.getApplicationKeyWithHttpInfoAsync(appKeyId, parameters).thenApply(response -> (ApplicationKeyResponse)response.getData());
    }

    public ApiResponse<ApplicationKeyResponse> getApplicationKeyWithHttpInfo(String appKeyId, GetApplicationKeyOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling getApplicationKey");
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/application_keys/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarHeaderParams.put("DD-OPERATION-ID", "getApplicationKey");
        Invocation.Builder builder = this.apiClient.createBuilder("KeyManagementApi.getApplicationKey", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationKeyResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApplicationKeyResponse>> getApplicationKeyWithHttpInfoAsync(String appKeyId, GetApplicationKeyOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (appKeyId == null) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appKeyId' when calling getApplicationKey"));
            return result;
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/application_keys/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarHeaderParams.put("DD-OPERATION-ID", "getApplicationKey");
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.getApplicationKey", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationKeyResponse>(){});
    }

    public ApplicationKeyResponse getCurrentUserApplicationKey(String appKeyId) throws ApiException {
        return this.getCurrentUserApplicationKeyWithHttpInfo(appKeyId).getData();
    }

    public CompletableFuture<ApplicationKeyResponse> getCurrentUserApplicationKeyAsync(String appKeyId) {
        return this.getCurrentUserApplicationKeyWithHttpInfoAsync(appKeyId).thenApply(response -> (ApplicationKeyResponse)response.getData());
    }

    public ApiResponse<ApplicationKeyResponse> getCurrentUserApplicationKeyWithHttpInfo(String appKeyId) throws ApiException {
        Object localVarPostBody = null;
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling getCurrentUserApplicationKey");
        }
        String localVarPath = "/api/v2/current_user/application_keys/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getCurrentUserApplicationKey");
        Invocation.Builder builder = this.apiClient.createBuilder("KeyManagementApi.getCurrentUserApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationKeyResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApplicationKeyResponse>> getCurrentUserApplicationKeyWithHttpInfoAsync(String appKeyId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (appKeyId == null) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appKeyId' when calling getCurrentUserApplicationKey"));
            return result;
        }
        String localVarPath = "/api/v2/current_user/application_keys/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getCurrentUserApplicationKey");
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.getCurrentUserApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationKeyResponse>(){});
    }

    public APIKeysResponse listAPIKeys() throws ApiException {
        return this.listAPIKeysWithHttpInfo(new ListAPIKeysOptionalParameters()).getData();
    }

    public CompletableFuture<APIKeysResponse> listAPIKeysAsync() {
        return this.listAPIKeysWithHttpInfoAsync(new ListAPIKeysOptionalParameters()).thenApply(response -> (APIKeysResponse)response.getData());
    }

    public APIKeysResponse listAPIKeys(ListAPIKeysOptionalParameters parameters) throws ApiException {
        return this.listAPIKeysWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<APIKeysResponse> listAPIKeysAsync(ListAPIKeysOptionalParameters parameters) {
        return this.listAPIKeysWithHttpInfoAsync(parameters).thenApply(response -> (APIKeysResponse)response.getData());
    }

    public ApiResponse<APIKeysResponse> listAPIKeysWithHttpInfo(ListAPIKeysOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        APIKeysSort sort = parameters.sort;
        String filter = parameters.filter;
        String filterCreatedAtStart = parameters.filterCreatedAtStart;
        String filterCreatedAtEnd = parameters.filterCreatedAtEnd;
        String filterModifiedAtStart = parameters.filterModifiedAtStart;
        String filterModifiedAtEnd = parameters.filterModifiedAtEnd;
        String include = parameters.include;
        String localVarPath = "/api/v2/api_keys";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][start]", filterCreatedAtStart));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][end]", filterCreatedAtEnd));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[modified_at][start]", filterModifiedAtStart));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[modified_at][end]", filterModifiedAtEnd));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarHeaderParams.put("DD-OPERATION-ID", "listAPIKeys");
        Invocation.Builder builder = this.apiClient.createBuilder("KeyManagementApi.listAPIKeys", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<APIKeysResponse>(){});
    }

    public CompletableFuture<ApiResponse<APIKeysResponse>> listAPIKeysWithHttpInfoAsync(ListAPIKeysOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        APIKeysSort sort = parameters.sort;
        String filter = parameters.filter;
        String filterCreatedAtStart = parameters.filterCreatedAtStart;
        String filterCreatedAtEnd = parameters.filterCreatedAtEnd;
        String filterModifiedAtStart = parameters.filterModifiedAtStart;
        String filterModifiedAtEnd = parameters.filterModifiedAtEnd;
        String include = parameters.include;
        String localVarPath = "/api/v2/api_keys";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][start]", filterCreatedAtStart));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][end]", filterCreatedAtEnd));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[modified_at][start]", filterModifiedAtStart));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[modified_at][end]", filterModifiedAtEnd));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarHeaderParams.put("DD-OPERATION-ID", "listAPIKeys");
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.listAPIKeys", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<APIKeysResponse>> result = new CompletableFuture<ApiResponse<APIKeysResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<APIKeysResponse>(){});
    }

    public ListApplicationKeysResponse listApplicationKeys() throws ApiException {
        return this.listApplicationKeysWithHttpInfo(new ListApplicationKeysOptionalParameters()).getData();
    }

    public CompletableFuture<ListApplicationKeysResponse> listApplicationKeysAsync() {
        return this.listApplicationKeysWithHttpInfoAsync(new ListApplicationKeysOptionalParameters()).thenApply(response -> (ListApplicationKeysResponse)response.getData());
    }

    public ListApplicationKeysResponse listApplicationKeys(ListApplicationKeysOptionalParameters parameters) throws ApiException {
        return this.listApplicationKeysWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ListApplicationKeysResponse> listApplicationKeysAsync(ListApplicationKeysOptionalParameters parameters) {
        return this.listApplicationKeysWithHttpInfoAsync(parameters).thenApply(response -> (ListApplicationKeysResponse)response.getData());
    }

    public ApiResponse<ListApplicationKeysResponse> listApplicationKeysWithHttpInfo(ListApplicationKeysOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        ApplicationKeysSort sort = parameters.sort;
        String filter = parameters.filter;
        String filterCreatedAtStart = parameters.filterCreatedAtStart;
        String filterCreatedAtEnd = parameters.filterCreatedAtEnd;
        String localVarPath = "/api/v2/application_keys";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][start]", filterCreatedAtStart));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][end]", filterCreatedAtEnd));
        localVarHeaderParams.put("DD-OPERATION-ID", "listApplicationKeys");
        Invocation.Builder builder = this.apiClient.createBuilder("KeyManagementApi.listApplicationKeys", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListApplicationKeysResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListApplicationKeysResponse>> listApplicationKeysWithHttpInfoAsync(ListApplicationKeysOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        ApplicationKeysSort sort = parameters.sort;
        String filter = parameters.filter;
        String filterCreatedAtStart = parameters.filterCreatedAtStart;
        String filterCreatedAtEnd = parameters.filterCreatedAtEnd;
        String localVarPath = "/api/v2/application_keys";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][start]", filterCreatedAtStart));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][end]", filterCreatedAtEnd));
        localVarHeaderParams.put("DD-OPERATION-ID", "listApplicationKeys");
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.listApplicationKeys", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListApplicationKeysResponse>> result = new CompletableFuture<ApiResponse<ListApplicationKeysResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListApplicationKeysResponse>(){});
    }

    public ListApplicationKeysResponse listCurrentUserApplicationKeys() throws ApiException {
        return this.listCurrentUserApplicationKeysWithHttpInfo(new ListCurrentUserApplicationKeysOptionalParameters()).getData();
    }

    public CompletableFuture<ListApplicationKeysResponse> listCurrentUserApplicationKeysAsync() {
        return this.listCurrentUserApplicationKeysWithHttpInfoAsync(new ListCurrentUserApplicationKeysOptionalParameters()).thenApply(response -> (ListApplicationKeysResponse)response.getData());
    }

    public ListApplicationKeysResponse listCurrentUserApplicationKeys(ListCurrentUserApplicationKeysOptionalParameters parameters) throws ApiException {
        return this.listCurrentUserApplicationKeysWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ListApplicationKeysResponse> listCurrentUserApplicationKeysAsync(ListCurrentUserApplicationKeysOptionalParameters parameters) {
        return this.listCurrentUserApplicationKeysWithHttpInfoAsync(parameters).thenApply(response -> (ListApplicationKeysResponse)response.getData());
    }

    public ApiResponse<ListApplicationKeysResponse> listCurrentUserApplicationKeysWithHttpInfo(ListCurrentUserApplicationKeysOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        ApplicationKeysSort sort = parameters.sort;
        String filter = parameters.filter;
        String filterCreatedAtStart = parameters.filterCreatedAtStart;
        String filterCreatedAtEnd = parameters.filterCreatedAtEnd;
        String localVarPath = "/api/v2/current_user/application_keys";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][start]", filterCreatedAtStart));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][end]", filterCreatedAtEnd));
        localVarHeaderParams.put("DD-OPERATION-ID", "listCurrentUserApplicationKeys");
        Invocation.Builder builder = this.apiClient.createBuilder("KeyManagementApi.listCurrentUserApplicationKeys", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListApplicationKeysResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListApplicationKeysResponse>> listCurrentUserApplicationKeysWithHttpInfoAsync(ListCurrentUserApplicationKeysOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        ApplicationKeysSort sort = parameters.sort;
        String filter = parameters.filter;
        String filterCreatedAtStart = parameters.filterCreatedAtStart;
        String filterCreatedAtEnd = parameters.filterCreatedAtEnd;
        String localVarPath = "/api/v2/current_user/application_keys";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][start]", filterCreatedAtStart));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][end]", filterCreatedAtEnd));
        localVarHeaderParams.put("DD-OPERATION-ID", "listCurrentUserApplicationKeys");
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.listCurrentUserApplicationKeys", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListApplicationKeysResponse>> result = new CompletableFuture<ApiResponse<ListApplicationKeysResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListApplicationKeysResponse>(){});
    }

    public APIKeyResponse updateAPIKey(String apiKeyId, APIKeyUpdateRequest body) throws ApiException {
        return this.updateAPIKeyWithHttpInfo(apiKeyId, body).getData();
    }

    public CompletableFuture<APIKeyResponse> updateAPIKeyAsync(String apiKeyId, APIKeyUpdateRequest body) {
        return this.updateAPIKeyWithHttpInfoAsync(apiKeyId, body).thenApply(response -> (APIKeyResponse)response.getData());
    }

    public ApiResponse<APIKeyResponse> updateAPIKeyWithHttpInfo(String apiKeyId, APIKeyUpdateRequest body) throws ApiException {
        APIKeyUpdateRequest localVarPostBody = body;
        if (apiKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'apiKeyId' when calling updateAPIKey");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateAPIKey");
        }
        String localVarPath = "/api/v2/api_keys/{api_key_id}".replaceAll("\\{api_key_id\\}", this.apiClient.escapeString(apiKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateAPIKey");
        Invocation.Builder builder = this.apiClient.createBuilder("KeyManagementApi.updateAPIKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<APIKeyResponse>(){});
    }

    public CompletableFuture<ApiResponse<APIKeyResponse>> updateAPIKeyWithHttpInfoAsync(String apiKeyId, APIKeyUpdateRequest body) {
        Invocation.Builder builder;
        APIKeyUpdateRequest localVarPostBody = body;
        if (apiKeyId == null) {
            CompletableFuture<ApiResponse<APIKeyResponse>> result = new CompletableFuture<ApiResponse<APIKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'apiKeyId' when calling updateAPIKey"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<APIKeyResponse>> result = new CompletableFuture<ApiResponse<APIKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateAPIKey"));
            return result;
        }
        String localVarPath = "/api/v2/api_keys/{api_key_id}".replaceAll("\\{api_key_id\\}", this.apiClient.escapeString(apiKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateAPIKey");
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.updateAPIKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<APIKeyResponse>> result = new CompletableFuture<ApiResponse<APIKeyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<APIKeyResponse>(){});
    }

    public ApplicationKeyResponse updateApplicationKey(String appKeyId, ApplicationKeyUpdateRequest body) throws ApiException {
        return this.updateApplicationKeyWithHttpInfo(appKeyId, body).getData();
    }

    public CompletableFuture<ApplicationKeyResponse> updateApplicationKeyAsync(String appKeyId, ApplicationKeyUpdateRequest body) {
        return this.updateApplicationKeyWithHttpInfoAsync(appKeyId, body).thenApply(response -> (ApplicationKeyResponse)response.getData());
    }

    public ApiResponse<ApplicationKeyResponse> updateApplicationKeyWithHttpInfo(String appKeyId, ApplicationKeyUpdateRequest body) throws ApiException {
        ApplicationKeyUpdateRequest localVarPostBody = body;
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling updateApplicationKey");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateApplicationKey");
        }
        String localVarPath = "/api/v2/application_keys/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateApplicationKey");
        Invocation.Builder builder = this.apiClient.createBuilder("KeyManagementApi.updateApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationKeyResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApplicationKeyResponse>> updateApplicationKeyWithHttpInfoAsync(String appKeyId, ApplicationKeyUpdateRequest body) {
        Invocation.Builder builder;
        ApplicationKeyUpdateRequest localVarPostBody = body;
        if (appKeyId == null) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appKeyId' when calling updateApplicationKey"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateApplicationKey"));
            return result;
        }
        String localVarPath = "/api/v2/application_keys/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateApplicationKey");
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.updateApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationKeyResponse>(){});
    }

    public ApplicationKeyResponse updateCurrentUserApplicationKey(String appKeyId, ApplicationKeyUpdateRequest body) throws ApiException {
        return this.updateCurrentUserApplicationKeyWithHttpInfo(appKeyId, body).getData();
    }

    public CompletableFuture<ApplicationKeyResponse> updateCurrentUserApplicationKeyAsync(String appKeyId, ApplicationKeyUpdateRequest body) {
        return this.updateCurrentUserApplicationKeyWithHttpInfoAsync(appKeyId, body).thenApply(response -> (ApplicationKeyResponse)response.getData());
    }

    public ApiResponse<ApplicationKeyResponse> updateCurrentUserApplicationKeyWithHttpInfo(String appKeyId, ApplicationKeyUpdateRequest body) throws ApiException {
        ApplicationKeyUpdateRequest localVarPostBody = body;
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling updateCurrentUserApplicationKey");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCurrentUserApplicationKey");
        }
        String localVarPath = "/api/v2/current_user/application_keys/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateCurrentUserApplicationKey");
        Invocation.Builder builder = this.apiClient.createBuilder("KeyManagementApi.updateCurrentUserApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationKeyResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApplicationKeyResponse>> updateCurrentUserApplicationKeyWithHttpInfoAsync(String appKeyId, ApplicationKeyUpdateRequest body) {
        Invocation.Builder builder;
        ApplicationKeyUpdateRequest localVarPostBody = body;
        if (appKeyId == null) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appKeyId' when calling updateCurrentUserApplicationKey"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateCurrentUserApplicationKey"));
            return result;
        }
        String localVarPath = "/api/v2/current_user/application_keys/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateCurrentUserApplicationKey");
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.updateCurrentUserApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationKeyResponse>(){});
    }

    public static class ListCurrentUserApplicationKeysOptionalParameters {
        private Long pageSize;
        private Long pageNumber;
        private ApplicationKeysSort sort;
        private String filter;
        private String filterCreatedAtStart;
        private String filterCreatedAtEnd;

        public ListCurrentUserApplicationKeysOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListCurrentUserApplicationKeysOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListCurrentUserApplicationKeysOptionalParameters sort(ApplicationKeysSort sort) {
            this.sort = sort;
            return this;
        }

        public ListCurrentUserApplicationKeysOptionalParameters filter(String filter) {
            this.filter = filter;
            return this;
        }

        public ListCurrentUserApplicationKeysOptionalParameters filterCreatedAtStart(String filterCreatedAtStart) {
            this.filterCreatedAtStart = filterCreatedAtStart;
            return this;
        }

        public ListCurrentUserApplicationKeysOptionalParameters filterCreatedAtEnd(String filterCreatedAtEnd) {
            this.filterCreatedAtEnd = filterCreatedAtEnd;
            return this;
        }
    }

    public static class ListApplicationKeysOptionalParameters {
        private Long pageSize;
        private Long pageNumber;
        private ApplicationKeysSort sort;
        private String filter;
        private String filterCreatedAtStart;
        private String filterCreatedAtEnd;

        public ListApplicationKeysOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListApplicationKeysOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListApplicationKeysOptionalParameters sort(ApplicationKeysSort sort) {
            this.sort = sort;
            return this;
        }

        public ListApplicationKeysOptionalParameters filter(String filter) {
            this.filter = filter;
            return this;
        }

        public ListApplicationKeysOptionalParameters filterCreatedAtStart(String filterCreatedAtStart) {
            this.filterCreatedAtStart = filterCreatedAtStart;
            return this;
        }

        public ListApplicationKeysOptionalParameters filterCreatedAtEnd(String filterCreatedAtEnd) {
            this.filterCreatedAtEnd = filterCreatedAtEnd;
            return this;
        }
    }

    public static class ListAPIKeysOptionalParameters {
        private Long pageSize;
        private Long pageNumber;
        private APIKeysSort sort;
        private String filter;
        private String filterCreatedAtStart;
        private String filterCreatedAtEnd;
        private String filterModifiedAtStart;
        private String filterModifiedAtEnd;
        private String include;

        public ListAPIKeysOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListAPIKeysOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListAPIKeysOptionalParameters sort(APIKeysSort sort) {
            this.sort = sort;
            return this;
        }

        public ListAPIKeysOptionalParameters filter(String filter) {
            this.filter = filter;
            return this;
        }

        public ListAPIKeysOptionalParameters filterCreatedAtStart(String filterCreatedAtStart) {
            this.filterCreatedAtStart = filterCreatedAtStart;
            return this;
        }

        public ListAPIKeysOptionalParameters filterCreatedAtEnd(String filterCreatedAtEnd) {
            this.filterCreatedAtEnd = filterCreatedAtEnd;
            return this;
        }

        public ListAPIKeysOptionalParameters filterModifiedAtStart(String filterModifiedAtStart) {
            this.filterModifiedAtStart = filterModifiedAtStart;
            return this;
        }

        public ListAPIKeysOptionalParameters filterModifiedAtEnd(String filterModifiedAtEnd) {
            this.filterModifiedAtEnd = filterModifiedAtEnd;
            return this;
        }

        public ListAPIKeysOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }

    public static class GetApplicationKeyOptionalParameters {
        private String include;

        public GetApplicationKeyOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }

    public static class GetAPIKeyOptionalParameters {
        private String include;

        public GetAPIKeyOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }
}

