/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.LogsMetricResponseAttributes;
import com.datadog.api.v2.client.model.LogsMetricType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The log-based metric properties.")
@JsonPropertyOrder(value={"attributes", "id", "type"})
public class LogsMetricResponseData {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private LogsMetricResponseAttributes attributes;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsMetricType type = LogsMetricType.LOGS_METRICS;

    public LogsMetricResponseData attributes(LogsMetricResponseAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsMetricResponseAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(LogsMetricResponseAttributes attributes) {
        this.attributes = attributes;
    }

    public LogsMetricResponseData id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="logs.page.load.count", value="The name of the log-based metric.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public LogsMetricResponseData type(LogsMetricType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsMetricType getType() {
        return this.type;
    }

    public void setType(LogsMetricType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsMetricResponseData logsMetricResponseData = (LogsMetricResponseData)o;
        return Objects.equals(this.attributes, logsMetricResponseData.attributes) && Objects.equals(this.id, logsMetricResponseData.id) && Objects.equals(this.type, logsMetricResponseData.type);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.id, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsMetricResponseData {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

