/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Update an existing Cloud Workload Security Agent rule.")
@JsonPropertyOrder(value={"description", "enabled", "expression"})
public class CloudWorkloadSecurityAgentRuleUpdateAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled;
    public static final String JSON_PROPERTY_EXPRESSION = "expression";
    private String expression;

    public CloudWorkloadSecurityAgentRuleUpdateAttributes description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="My Agent rule", value="The description of the Agent rule.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CloudWorkloadSecurityAgentRuleUpdateAttributes enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether the Agent rule is enabled.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public CloudWorkloadSecurityAgentRuleUpdateAttributes expression(String expression) {
        this.expression = expression;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="exec.file.name == \\\"sh\\\"", value="The SECL expression of the Agent rule.")
    @JsonProperty(value="expression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudWorkloadSecurityAgentRuleUpdateAttributes cloudWorkloadSecurityAgentRuleUpdateAttributes = (CloudWorkloadSecurityAgentRuleUpdateAttributes)o;
        return Objects.equals(this.description, cloudWorkloadSecurityAgentRuleUpdateAttributes.description) && Objects.equals(this.enabled, cloudWorkloadSecurityAgentRuleUpdateAttributes.enabled) && Objects.equals(this.expression, cloudWorkloadSecurityAgentRuleUpdateAttributes.expression);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.enabled, this.expression);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CloudWorkloadSecurityAgentRuleUpdateAttributes {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    expression: ").append(this.toIndentedString(this.expression)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

