/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Attributes used to create an application Key.")
@JsonPropertyOrder(value={"name", "scopes"})
public class ApplicationKeyCreateAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private JsonNullable<List<String>> scopes = JsonNullable.undefined();

    public ApplicationKeyCreateAttributes() {
    }

    @JsonCreator
    public ApplicationKeyCreateAttributes(@JsonProperty(required=true, value="name") String name) {
        this.name = name;
    }

    public ApplicationKeyCreateAttributes name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Application Key for managing dashboards", required=true, value="Name of the application key.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApplicationKeyCreateAttributes scopes(List<String> scopes) {
        this.scopes = JsonNullable.of(scopes);
        return this;
    }

    public ApplicationKeyCreateAttributes addScopesItem(String scopesItem) {
        if (this.scopes == null || !this.scopes.isPresent()) {
            this.scopes = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.scopes.get()).add(scopesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"dashboards_read\",\"dashboards_write\",\"dashboards_public_share\"]", value="Array of scopes to grant the application key. This feature is in private beta, please contact Datadog support to enable scopes for your application keys.")
    @JsonIgnore
    public List<String> getScopes() {
        return (List)this.scopes.orElse(null);
    }

    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getScopes_JsonNullable() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    public void setScopes_JsonNullable(JsonNullable<List<String>> scopes) {
        this.scopes = scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = JsonNullable.of(scopes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationKeyCreateAttributes applicationKeyCreateAttributes = (ApplicationKeyCreateAttributes)o;
        return Objects.equals(this.name, applicationKeyCreateAttributes.name) && Objects.equals(this.scopes, applicationKeyCreateAttributes.scopes);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.scopes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationKeyCreateAttributes {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

