/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.CloudWorkloadSecurityAgentRuleCreateRequest;
import com.datadog.api.v2.client.model.CloudWorkloadSecurityAgentRuleResponse;
import com.datadog.api.v2.client.model.CloudWorkloadSecurityAgentRuleUpdateRequest;
import com.datadog.api.v2.client.model.CloudWorkloadSecurityAgentRulesListResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class CloudWorkloadSecurityApi {
    private ApiClient apiClient;

    public CloudWorkloadSecurityApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CloudWorkloadSecurityApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CloudWorkloadSecurityAgentRuleResponse createCloudWorkloadSecurityAgentRule(CloudWorkloadSecurityAgentRuleCreateRequest body) throws ApiException {
        return this.createCloudWorkloadSecurityAgentRuleWithHttpInfo(body).getData();
    }

    public ApiResponse<CloudWorkloadSecurityAgentRuleResponse> createCloudWorkloadSecurityAgentRuleWithHttpInfo(CloudWorkloadSecurityAgentRuleCreateRequest body) throws ApiException {
        CloudWorkloadSecurityAgentRuleCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCloudWorkloadSecurityAgentRule");
        }
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createCloudWorkloadSecurityAgentRule");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<CloudWorkloadSecurityAgentRuleResponse> localVarReturnType = new GenericType<CloudWorkloadSecurityAgentRuleResponse>(){};
        return this.apiClient.invokeAPI("CloudWorkloadSecurityApi.createCloudWorkloadSecurityAgentRule", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void deleteCloudWorkloadSecurityAgentRule(String agentRuleId) throws ApiException {
        this.deleteCloudWorkloadSecurityAgentRuleWithHttpInfo(agentRuleId);
    }

    public ApiResponse<Void> deleteCloudWorkloadSecurityAgentRuleWithHttpInfo(String agentRuleId) throws ApiException {
        Object localVarPostBody = null;
        if (agentRuleId == null) {
            throw new ApiException(400, "Missing the required parameter 'agentRuleId' when calling deleteCloudWorkloadSecurityAgentRule");
        }
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules/{agent_rule_id}".replaceAll("\\{agent_rule_id\\}", this.apiClient.escapeString(agentRuleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteCloudWorkloadSecurityAgentRule");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("CloudWorkloadSecurityApi.deleteCloudWorkloadSecurityAgentRule", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public File downloadCloudWorkloadPolicyFile() throws ApiException {
        return this.downloadCloudWorkloadPolicyFileWithHttpInfo().getData();
    }

    public ApiResponse<File> downloadCloudWorkloadPolicyFileWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/security/cloud_workload/policy/download";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "downloadCloudWorkloadPolicyFile");
        String[] localVarAccepts = new String[]{"application/yaml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<File> localVarReturnType = new GenericType<File>(){};
        return this.apiClient.invokeAPI("CloudWorkloadSecurityApi.downloadCloudWorkloadPolicyFile", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public CloudWorkloadSecurityAgentRuleResponse getCloudWorkloadSecurityAgentRule(String agentRuleId) throws ApiException {
        return this.getCloudWorkloadSecurityAgentRuleWithHttpInfo(agentRuleId).getData();
    }

    public ApiResponse<CloudWorkloadSecurityAgentRuleResponse> getCloudWorkloadSecurityAgentRuleWithHttpInfo(String agentRuleId) throws ApiException {
        Object localVarPostBody = null;
        if (agentRuleId == null) {
            throw new ApiException(400, "Missing the required parameter 'agentRuleId' when calling getCloudWorkloadSecurityAgentRule");
        }
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules/{agent_rule_id}".replaceAll("\\{agent_rule_id\\}", this.apiClient.escapeString(agentRuleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getCloudWorkloadSecurityAgentRule");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<CloudWorkloadSecurityAgentRuleResponse> localVarReturnType = new GenericType<CloudWorkloadSecurityAgentRuleResponse>(){};
        return this.apiClient.invokeAPI("CloudWorkloadSecurityApi.getCloudWorkloadSecurityAgentRule", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public CloudWorkloadSecurityAgentRulesListResponse listCloudWorkloadSecurityAgentRules() throws ApiException {
        return this.listCloudWorkloadSecurityAgentRulesWithHttpInfo().getData();
    }

    public ApiResponse<CloudWorkloadSecurityAgentRulesListResponse> listCloudWorkloadSecurityAgentRulesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listCloudWorkloadSecurityAgentRules");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<CloudWorkloadSecurityAgentRulesListResponse> localVarReturnType = new GenericType<CloudWorkloadSecurityAgentRulesListResponse>(){};
        return this.apiClient.invokeAPI("CloudWorkloadSecurityApi.listCloudWorkloadSecurityAgentRules", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public CloudWorkloadSecurityAgentRuleResponse updateCloudWorkloadSecurityAgentRule(String agentRuleId, CloudWorkloadSecurityAgentRuleUpdateRequest body) throws ApiException {
        return this.updateCloudWorkloadSecurityAgentRuleWithHttpInfo(agentRuleId, body).getData();
    }

    public ApiResponse<CloudWorkloadSecurityAgentRuleResponse> updateCloudWorkloadSecurityAgentRuleWithHttpInfo(String agentRuleId, CloudWorkloadSecurityAgentRuleUpdateRequest body) throws ApiException {
        CloudWorkloadSecurityAgentRuleUpdateRequest localVarPostBody = body;
        if (agentRuleId == null) {
            throw new ApiException(400, "Missing the required parameter 'agentRuleId' when calling updateCloudWorkloadSecurityAgentRule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCloudWorkloadSecurityAgentRule");
        }
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules/{agent_rule_id}".replaceAll("\\{agent_rule_id\\}", this.apiClient.escapeString(agentRuleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateCloudWorkloadSecurityAgentRule");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<CloudWorkloadSecurityAgentRuleResponse> localVarReturnType = new GenericType<CloudWorkloadSecurityAgentRuleResponse>(){};
        return this.apiClient.invokeAPI("CloudWorkloadSecurityApi.updateCloudWorkloadSecurityAgentRule", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }
}

