/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=WidgetMessageDisplaySerializer.class)
public class WidgetMessageDisplay {
    public static final WidgetMessageDisplay INLINE = new WidgetMessageDisplay("inline");
    public static final WidgetMessageDisplay EXPANDED_MEDIUM = new WidgetMessageDisplay("expanded-md");
    public static final WidgetMessageDisplay EXPANDED_LARGE = new WidgetMessageDisplay("expanded-lg");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("inline", "expanded-md", "expanded-lg"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    WidgetMessageDisplay(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((WidgetMessageDisplay)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static WidgetMessageDisplay fromValue(String value) {
        return new WidgetMessageDisplay(value);
    }

    public static class WidgetMessageDisplaySerializer
    extends StdSerializer<WidgetMessageDisplay> {
        public WidgetMessageDisplaySerializer(Class<WidgetMessageDisplay> t) {
            super(t);
        }

        public WidgetMessageDisplaySerializer() {
            this(null);
        }

        public void serialize(WidgetMessageDisplay value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

