/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=TreeMapGroupBySerializer.class)
public class TreeMapGroupBy {
    public static final TreeMapGroupBy USER = new TreeMapGroupBy("user");
    public static final TreeMapGroupBy FAMILY = new TreeMapGroupBy("family");
    public static final TreeMapGroupBy PROCESS = new TreeMapGroupBy("process");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("user", "family", "process"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    TreeMapGroupBy(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((TreeMapGroupBy)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static TreeMapGroupBy fromValue(String value) {
        return new TreeMapGroupBy(value);
    }

    public static class TreeMapGroupBySerializer
    extends StdSerializer<TreeMapGroupBy> {
        public TreeMapGroupBySerializer(Class<TreeMapGroupBy> t) {
            super(t);
        }

        public TreeMapGroupBySerializer() {
            this(null);
        }

        public void serialize(TreeMapGroupBy value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

