/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.HourlyUsageAttributionResponse;
import com.datadog.api.v1.client.model.HourlyUsageAttributionUsageType;
import com.datadog.api.v1.client.model.MonthlyUsageAttributionResponse;
import com.datadog.api.v1.client.model.MonthlyUsageAttributionSupportedMetrics;
import com.datadog.api.v1.client.model.UsageAnalyzedLogsResponse;
import com.datadog.api.v1.client.model.UsageAttributionResponse;
import com.datadog.api.v1.client.model.UsageAttributionSort;
import com.datadog.api.v1.client.model.UsageAttributionSupportedMetrics;
import com.datadog.api.v1.client.model.UsageAuditLogsResponse;
import com.datadog.api.v1.client.model.UsageBillableSummaryResponse;
import com.datadog.api.v1.client.model.UsageCWSResponse;
import com.datadog.api.v1.client.model.UsageCloudSecurityPostureManagementResponse;
import com.datadog.api.v1.client.model.UsageCustomReportsResponse;
import com.datadog.api.v1.client.model.UsageDBMResponse;
import com.datadog.api.v1.client.model.UsageFargateResponse;
import com.datadog.api.v1.client.model.UsageHostsResponse;
import com.datadog.api.v1.client.model.UsageIncidentManagementResponse;
import com.datadog.api.v1.client.model.UsageIndexedSpansResponse;
import com.datadog.api.v1.client.model.UsageIngestedSpansResponse;
import com.datadog.api.v1.client.model.UsageIoTResponse;
import com.datadog.api.v1.client.model.UsageLambdaResponse;
import com.datadog.api.v1.client.model.UsageLogsByIndexResponse;
import com.datadog.api.v1.client.model.UsageLogsByRetentionResponse;
import com.datadog.api.v1.client.model.UsageLogsResponse;
import com.datadog.api.v1.client.model.UsageNetworkFlowsResponse;
import com.datadog.api.v1.client.model.UsageNetworkHostsResponse;
import com.datadog.api.v1.client.model.UsageProfilingResponse;
import com.datadog.api.v1.client.model.UsageRumSessionsResponse;
import com.datadog.api.v1.client.model.UsageRumUnitsResponse;
import com.datadog.api.v1.client.model.UsageSDSResponse;
import com.datadog.api.v1.client.model.UsageSNMPResponse;
import com.datadog.api.v1.client.model.UsageSort;
import com.datadog.api.v1.client.model.UsageSortDirection;
import com.datadog.api.v1.client.model.UsageSpecifiedCustomReportsResponse;
import com.datadog.api.v1.client.model.UsageSummaryResponse;
import com.datadog.api.v1.client.model.UsageSyntheticsAPIResponse;
import com.datadog.api.v1.client.model.UsageSyntheticsBrowserResponse;
import com.datadog.api.v1.client.model.UsageSyntheticsResponse;
import com.datadog.api.v1.client.model.UsageTimeseriesResponse;
import com.datadog.api.v1.client.model.UsageTopAvgMetricsResponse;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class UsageMeteringApi {
    private ApiClient apiClient;

    public UsageMeteringApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UsageMeteringApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public UsageCustomReportsResponse getDailyCustomReports() throws ApiException {
        return this.getDailyCustomReportsWithHttpInfo(new GetDailyCustomReportsOptionalParameters()).getData();
    }

    public UsageCustomReportsResponse getDailyCustomReports(GetDailyCustomReportsOptionalParameters parameters) throws ApiException {
        return this.getDailyCustomReportsWithHttpInfo(parameters).getData();
    }

    public ApiResponse<UsageCustomReportsResponse> getDailyCustomReportsWithHttpInfo(GetDailyCustomReportsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        UsageSortDirection sortDir = parameters.sortDir;
        UsageSort sort = parameters.sort;
        String localVarPath = "/api/v1/daily_custom_reports";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_dir", sortDir));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarHeaderParams.put("DD-OPERATION-ID", "getDailyCustomReports");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageCustomReportsResponse> localVarReturnType = new GenericType<UsageCustomReportsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getDailyCustomReports", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public HourlyUsageAttributionResponse getHourlyUsageAttribution(OffsetDateTime startHr, HourlyUsageAttributionUsageType usageType) throws ApiException {
        return this.getHourlyUsageAttributionWithHttpInfo(startHr, usageType, new GetHourlyUsageAttributionOptionalParameters()).getData();
    }

    public HourlyUsageAttributionResponse getHourlyUsageAttribution(OffsetDateTime startHr, HourlyUsageAttributionUsageType usageType, GetHourlyUsageAttributionOptionalParameters parameters) throws ApiException {
        return this.getHourlyUsageAttributionWithHttpInfo(startHr, usageType, parameters).getData();
    }

    public ApiResponse<HourlyUsageAttributionResponse> getHourlyUsageAttributionWithHttpInfo(OffsetDateTime startHr, HourlyUsageAttributionUsageType usageType, GetHourlyUsageAttributionOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getHourlyUsageAttribution");
        }
        if (usageType == null) {
            throw new ApiException(400, "Missing the required parameter 'usageType' when calling getHourlyUsageAttribution");
        }
        OffsetDateTime endHr = parameters.endHr;
        String nextRecordId = parameters.nextRecordId;
        String tagBreakdownKeys = parameters.tagBreakdownKeys;
        String localVarPath = "/api/v1/usage/hourly-attribution";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "usage_type", usageType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "next_record_id", nextRecordId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tag_breakdown_keys", tagBreakdownKeys));
        localVarHeaderParams.put("DD-OPERATION-ID", "getHourlyUsageAttribution");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<HourlyUsageAttributionResponse> localVarReturnType = new GenericType<HourlyUsageAttributionResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getHourlyUsageAttribution", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageIncidentManagementResponse getIncidentManagement(OffsetDateTime startHr) throws ApiException {
        return this.getIncidentManagementWithHttpInfo(startHr, new GetIncidentManagementOptionalParameters()).getData();
    }

    public UsageIncidentManagementResponse getIncidentManagement(OffsetDateTime startHr, GetIncidentManagementOptionalParameters parameters) throws ApiException {
        return this.getIncidentManagementWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageIncidentManagementResponse> getIncidentManagementWithHttpInfo(OffsetDateTime startHr, GetIncidentManagementOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getIncidentManagement");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/incident-management";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getIncidentManagement");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageIncidentManagementResponse> localVarReturnType = new GenericType<UsageIncidentManagementResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getIncidentManagement", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageIngestedSpansResponse getIngestedSpans(OffsetDateTime startHr) throws ApiException {
        return this.getIngestedSpansWithHttpInfo(startHr, new GetIngestedSpansOptionalParameters()).getData();
    }

    public UsageIngestedSpansResponse getIngestedSpans(OffsetDateTime startHr, GetIngestedSpansOptionalParameters parameters) throws ApiException {
        return this.getIngestedSpansWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageIngestedSpansResponse> getIngestedSpansWithHttpInfo(OffsetDateTime startHr, GetIngestedSpansOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getIngestedSpans");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/ingested-spans";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getIngestedSpans");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageIngestedSpansResponse> localVarReturnType = new GenericType<UsageIngestedSpansResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getIngestedSpans", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageCustomReportsResponse getMonthlyCustomReports() throws ApiException {
        return this.getMonthlyCustomReportsWithHttpInfo(new GetMonthlyCustomReportsOptionalParameters()).getData();
    }

    public UsageCustomReportsResponse getMonthlyCustomReports(GetMonthlyCustomReportsOptionalParameters parameters) throws ApiException {
        return this.getMonthlyCustomReportsWithHttpInfo(parameters).getData();
    }

    public ApiResponse<UsageCustomReportsResponse> getMonthlyCustomReportsWithHttpInfo(GetMonthlyCustomReportsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        UsageSortDirection sortDir = parameters.sortDir;
        UsageSort sort = parameters.sort;
        String localVarPath = "/api/v1/monthly_custom_reports";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_dir", sortDir));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarHeaderParams.put("DD-OPERATION-ID", "getMonthlyCustomReports");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageCustomReportsResponse> localVarReturnType = new GenericType<UsageCustomReportsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getMonthlyCustomReports", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public MonthlyUsageAttributionResponse getMonthlyUsageAttribution(OffsetDateTime startMonth, MonthlyUsageAttributionSupportedMetrics fields) throws ApiException {
        return this.getMonthlyUsageAttributionWithHttpInfo(startMonth, fields, new GetMonthlyUsageAttributionOptionalParameters()).getData();
    }

    public MonthlyUsageAttributionResponse getMonthlyUsageAttribution(OffsetDateTime startMonth, MonthlyUsageAttributionSupportedMetrics fields, GetMonthlyUsageAttributionOptionalParameters parameters) throws ApiException {
        return this.getMonthlyUsageAttributionWithHttpInfo(startMonth, fields, parameters).getData();
    }

    public ApiResponse<MonthlyUsageAttributionResponse> getMonthlyUsageAttributionWithHttpInfo(OffsetDateTime startMonth, MonthlyUsageAttributionSupportedMetrics fields, GetMonthlyUsageAttributionOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startMonth == null) {
            throw new ApiException(400, "Missing the required parameter 'startMonth' when calling getMonthlyUsageAttribution");
        }
        if (fields == null) {
            throw new ApiException(400, "Missing the required parameter 'fields' when calling getMonthlyUsageAttribution");
        }
        OffsetDateTime endMonth = parameters.endMonth;
        UsageSortDirection sortDirection = parameters.sortDirection;
        MonthlyUsageAttributionSupportedMetrics sortName = parameters.sortName;
        String tagBreakdownKeys = parameters.tagBreakdownKeys;
        String nextRecordId = parameters.nextRecordId;
        String localVarPath = "/api/v1/usage/monthly-attribution";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_month", startMonth));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_month", endMonth));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fields", fields));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_direction", sortDirection));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_name", sortName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tag_breakdown_keys", tagBreakdownKeys));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "next_record_id", nextRecordId));
        localVarHeaderParams.put("DD-OPERATION-ID", "getMonthlyUsageAttribution");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<MonthlyUsageAttributionResponse> localVarReturnType = new GenericType<MonthlyUsageAttributionResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getMonthlyUsageAttribution", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageSpecifiedCustomReportsResponse getSpecifiedDailyCustomReports(String reportId) throws ApiException {
        return this.getSpecifiedDailyCustomReportsWithHttpInfo(reportId).getData();
    }

    public ApiResponse<UsageSpecifiedCustomReportsResponse> getSpecifiedDailyCustomReportsWithHttpInfo(String reportId) throws ApiException {
        Object localVarPostBody = null;
        if (reportId == null) {
            throw new ApiException(400, "Missing the required parameter 'reportId' when calling getSpecifiedDailyCustomReports");
        }
        String localVarPath = "/api/v1/daily_custom_reports/{report_id}".replaceAll("\\{report_id\\}", this.apiClient.escapeString(reportId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getSpecifiedDailyCustomReports");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSpecifiedCustomReportsResponse> localVarReturnType = new GenericType<UsageSpecifiedCustomReportsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getSpecifiedDailyCustomReports", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageSpecifiedCustomReportsResponse getSpecifiedMonthlyCustomReports(String reportId) throws ApiException {
        return this.getSpecifiedMonthlyCustomReportsWithHttpInfo(reportId).getData();
    }

    public ApiResponse<UsageSpecifiedCustomReportsResponse> getSpecifiedMonthlyCustomReportsWithHttpInfo(String reportId) throws ApiException {
        Object localVarPostBody = null;
        if (reportId == null) {
            throw new ApiException(400, "Missing the required parameter 'reportId' when calling getSpecifiedMonthlyCustomReports");
        }
        String localVarPath = "/api/v1/monthly_custom_reports/{report_id}".replaceAll("\\{report_id\\}", this.apiClient.escapeString(reportId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getSpecifiedMonthlyCustomReports");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSpecifiedCustomReportsResponse> localVarReturnType = new GenericType<UsageSpecifiedCustomReportsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getSpecifiedMonthlyCustomReports", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageAnalyzedLogsResponse getUsageAnalyzedLogs(OffsetDateTime startHr) throws ApiException {
        return this.getUsageAnalyzedLogsWithHttpInfo(startHr, new GetUsageAnalyzedLogsOptionalParameters()).getData();
    }

    public UsageAnalyzedLogsResponse getUsageAnalyzedLogs(OffsetDateTime startHr, GetUsageAnalyzedLogsOptionalParameters parameters) throws ApiException {
        return this.getUsageAnalyzedLogsWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageAnalyzedLogsResponse> getUsageAnalyzedLogsWithHttpInfo(OffsetDateTime startHr, GetUsageAnalyzedLogsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageAnalyzedLogs");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/analyzed_logs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageAnalyzedLogs");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageAnalyzedLogsResponse> localVarReturnType = new GenericType<UsageAnalyzedLogsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageAnalyzedLogs", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageAttributionResponse getUsageAttribution(OffsetDateTime startMonth, UsageAttributionSupportedMetrics fields) throws ApiException {
        return this.getUsageAttributionWithHttpInfo(startMonth, fields, new GetUsageAttributionOptionalParameters()).getData();
    }

    public UsageAttributionResponse getUsageAttribution(OffsetDateTime startMonth, UsageAttributionSupportedMetrics fields, GetUsageAttributionOptionalParameters parameters) throws ApiException {
        return this.getUsageAttributionWithHttpInfo(startMonth, fields, parameters).getData();
    }

    public ApiResponse<UsageAttributionResponse> getUsageAttributionWithHttpInfo(OffsetDateTime startMonth, UsageAttributionSupportedMetrics fields, GetUsageAttributionOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startMonth == null) {
            throw new ApiException(400, "Missing the required parameter 'startMonth' when calling getUsageAttribution");
        }
        if (fields == null) {
            throw new ApiException(400, "Missing the required parameter 'fields' when calling getUsageAttribution");
        }
        OffsetDateTime endMonth = parameters.endMonth;
        UsageSortDirection sortDirection = parameters.sortDirection;
        UsageAttributionSort sortName = parameters.sortName;
        Boolean includeDescendants = parameters.includeDescendants;
        Long offset = parameters.offset;
        Long limit = parameters.limit;
        String localVarPath = "/api/v1/usage/attribution";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_month", startMonth));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fields", fields));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_month", endMonth));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_direction", sortDirection));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_name", sortName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_descendants", includeDescendants));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageAttribution");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageAttributionResponse> localVarReturnType = new GenericType<UsageAttributionResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageAttribution", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageAuditLogsResponse getUsageAuditLogs(OffsetDateTime startHr) throws ApiException {
        return this.getUsageAuditLogsWithHttpInfo(startHr, new GetUsageAuditLogsOptionalParameters()).getData();
    }

    public UsageAuditLogsResponse getUsageAuditLogs(OffsetDateTime startHr, GetUsageAuditLogsOptionalParameters parameters) throws ApiException {
        return this.getUsageAuditLogsWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageAuditLogsResponse> getUsageAuditLogsWithHttpInfo(OffsetDateTime startHr, GetUsageAuditLogsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageAuditLogs");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/audit_logs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageAuditLogs");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageAuditLogsResponse> localVarReturnType = new GenericType<UsageAuditLogsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageAuditLogs", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageBillableSummaryResponse getUsageBillableSummary() throws ApiException {
        return this.getUsageBillableSummaryWithHttpInfo(new GetUsageBillableSummaryOptionalParameters()).getData();
    }

    public UsageBillableSummaryResponse getUsageBillableSummary(GetUsageBillableSummaryOptionalParameters parameters) throws ApiException {
        return this.getUsageBillableSummaryWithHttpInfo(parameters).getData();
    }

    public ApiResponse<UsageBillableSummaryResponse> getUsageBillableSummaryWithHttpInfo(GetUsageBillableSummaryOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        OffsetDateTime month = parameters.month;
        String localVarPath = "/api/v1/usage/billable-summary";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "month", month));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageBillableSummary");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageBillableSummaryResponse> localVarReturnType = new GenericType<UsageBillableSummaryResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageBillableSummary", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageCWSResponse getUsageCWS(OffsetDateTime startHr) throws ApiException {
        return this.getUsageCWSWithHttpInfo(startHr, new GetUsageCWSOptionalParameters()).getData();
    }

    public UsageCWSResponse getUsageCWS(OffsetDateTime startHr, GetUsageCWSOptionalParameters parameters) throws ApiException {
        return this.getUsageCWSWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageCWSResponse> getUsageCWSWithHttpInfo(OffsetDateTime startHr, GetUsageCWSOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageCWS");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/cws";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageCWS");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageCWSResponse> localVarReturnType = new GenericType<UsageCWSResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageCWS", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageCloudSecurityPostureManagementResponse getUsageCloudSecurityPostureManagement(OffsetDateTime startHr) throws ApiException {
        return this.getUsageCloudSecurityPostureManagementWithHttpInfo(startHr, new GetUsageCloudSecurityPostureManagementOptionalParameters()).getData();
    }

    public UsageCloudSecurityPostureManagementResponse getUsageCloudSecurityPostureManagement(OffsetDateTime startHr, GetUsageCloudSecurityPostureManagementOptionalParameters parameters) throws ApiException {
        return this.getUsageCloudSecurityPostureManagementWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageCloudSecurityPostureManagementResponse> getUsageCloudSecurityPostureManagementWithHttpInfo(OffsetDateTime startHr, GetUsageCloudSecurityPostureManagementOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageCloudSecurityPostureManagement");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/cspm";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageCloudSecurityPostureManagement");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageCloudSecurityPostureManagementResponse> localVarReturnType = new GenericType<UsageCloudSecurityPostureManagementResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageCloudSecurityPostureManagement", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageDBMResponse getUsageDBM(OffsetDateTime startHr) throws ApiException {
        return this.getUsageDBMWithHttpInfo(startHr, new GetUsageDBMOptionalParameters()).getData();
    }

    public UsageDBMResponse getUsageDBM(OffsetDateTime startHr, GetUsageDBMOptionalParameters parameters) throws ApiException {
        return this.getUsageDBMWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageDBMResponse> getUsageDBMWithHttpInfo(OffsetDateTime startHr, GetUsageDBMOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageDBM");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/dbm";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageDBM");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageDBMResponse> localVarReturnType = new GenericType<UsageDBMResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageDBM", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageFargateResponse getUsageFargate(OffsetDateTime startHr) throws ApiException {
        return this.getUsageFargateWithHttpInfo(startHr, new GetUsageFargateOptionalParameters()).getData();
    }

    public UsageFargateResponse getUsageFargate(OffsetDateTime startHr, GetUsageFargateOptionalParameters parameters) throws ApiException {
        return this.getUsageFargateWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageFargateResponse> getUsageFargateWithHttpInfo(OffsetDateTime startHr, GetUsageFargateOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageFargate");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/fargate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageFargate");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageFargateResponse> localVarReturnType = new GenericType<UsageFargateResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageFargate", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageHostsResponse getUsageHosts(OffsetDateTime startHr) throws ApiException {
        return this.getUsageHostsWithHttpInfo(startHr, new GetUsageHostsOptionalParameters()).getData();
    }

    public UsageHostsResponse getUsageHosts(OffsetDateTime startHr, GetUsageHostsOptionalParameters parameters) throws ApiException {
        return this.getUsageHostsWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageHostsResponse> getUsageHostsWithHttpInfo(OffsetDateTime startHr, GetUsageHostsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageHosts");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/hosts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageHosts");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageHostsResponse> localVarReturnType = new GenericType<UsageHostsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageHosts", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageIndexedSpansResponse getUsageIndexedSpans(OffsetDateTime startHr) throws ApiException {
        return this.getUsageIndexedSpansWithHttpInfo(startHr, new GetUsageIndexedSpansOptionalParameters()).getData();
    }

    public UsageIndexedSpansResponse getUsageIndexedSpans(OffsetDateTime startHr, GetUsageIndexedSpansOptionalParameters parameters) throws ApiException {
        return this.getUsageIndexedSpansWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageIndexedSpansResponse> getUsageIndexedSpansWithHttpInfo(OffsetDateTime startHr, GetUsageIndexedSpansOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageIndexedSpans");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/indexed-spans";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageIndexedSpans");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageIndexedSpansResponse> localVarReturnType = new GenericType<UsageIndexedSpansResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageIndexedSpans", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageIoTResponse getUsageInternetOfThings(OffsetDateTime startHr) throws ApiException {
        return this.getUsageInternetOfThingsWithHttpInfo(startHr, new GetUsageInternetOfThingsOptionalParameters()).getData();
    }

    public UsageIoTResponse getUsageInternetOfThings(OffsetDateTime startHr, GetUsageInternetOfThingsOptionalParameters parameters) throws ApiException {
        return this.getUsageInternetOfThingsWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageIoTResponse> getUsageInternetOfThingsWithHttpInfo(OffsetDateTime startHr, GetUsageInternetOfThingsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageInternetOfThings");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/iot";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageInternetOfThings");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageIoTResponse> localVarReturnType = new GenericType<UsageIoTResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageInternetOfThings", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageLambdaResponse getUsageLambda(OffsetDateTime startHr) throws ApiException {
        return this.getUsageLambdaWithHttpInfo(startHr, new GetUsageLambdaOptionalParameters()).getData();
    }

    public UsageLambdaResponse getUsageLambda(OffsetDateTime startHr, GetUsageLambdaOptionalParameters parameters) throws ApiException {
        return this.getUsageLambdaWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageLambdaResponse> getUsageLambdaWithHttpInfo(OffsetDateTime startHr, GetUsageLambdaOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageLambda");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/aws_lambda";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageLambda");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageLambdaResponse> localVarReturnType = new GenericType<UsageLambdaResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageLambda", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageLogsResponse getUsageLogs(OffsetDateTime startHr) throws ApiException {
        return this.getUsageLogsWithHttpInfo(startHr, new GetUsageLogsOptionalParameters()).getData();
    }

    public UsageLogsResponse getUsageLogs(OffsetDateTime startHr, GetUsageLogsOptionalParameters parameters) throws ApiException {
        return this.getUsageLogsWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageLogsResponse> getUsageLogsWithHttpInfo(OffsetDateTime startHr, GetUsageLogsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageLogs");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/logs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageLogs");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageLogsResponse> localVarReturnType = new GenericType<UsageLogsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageLogs", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageLogsByIndexResponse getUsageLogsByIndex(OffsetDateTime startHr) throws ApiException {
        return this.getUsageLogsByIndexWithHttpInfo(startHr, new GetUsageLogsByIndexOptionalParameters()).getData();
    }

    public UsageLogsByIndexResponse getUsageLogsByIndex(OffsetDateTime startHr, GetUsageLogsByIndexOptionalParameters parameters) throws ApiException {
        return this.getUsageLogsByIndexWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageLogsByIndexResponse> getUsageLogsByIndexWithHttpInfo(OffsetDateTime startHr, GetUsageLogsByIndexOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageLogsByIndex");
        }
        OffsetDateTime endHr = parameters.endHr;
        List indexName = parameters.indexName;
        String localVarPath = "/api/v1/usage/logs_by_index";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "index_name", indexName));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageLogsByIndex");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageLogsByIndexResponse> localVarReturnType = new GenericType<UsageLogsByIndexResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageLogsByIndex", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageLogsByRetentionResponse getUsageLogsByRetention(OffsetDateTime startHr) throws ApiException {
        return this.getUsageLogsByRetentionWithHttpInfo(startHr, new GetUsageLogsByRetentionOptionalParameters()).getData();
    }

    public UsageLogsByRetentionResponse getUsageLogsByRetention(OffsetDateTime startHr, GetUsageLogsByRetentionOptionalParameters parameters) throws ApiException {
        return this.getUsageLogsByRetentionWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageLogsByRetentionResponse> getUsageLogsByRetentionWithHttpInfo(OffsetDateTime startHr, GetUsageLogsByRetentionOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageLogsByRetention");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/logs-by-retention";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageLogsByRetention");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageLogsByRetentionResponse> localVarReturnType = new GenericType<UsageLogsByRetentionResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageLogsByRetention", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageNetworkFlowsResponse getUsageNetworkFlows(OffsetDateTime startHr) throws ApiException {
        return this.getUsageNetworkFlowsWithHttpInfo(startHr, new GetUsageNetworkFlowsOptionalParameters()).getData();
    }

    public UsageNetworkFlowsResponse getUsageNetworkFlows(OffsetDateTime startHr, GetUsageNetworkFlowsOptionalParameters parameters) throws ApiException {
        return this.getUsageNetworkFlowsWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageNetworkFlowsResponse> getUsageNetworkFlowsWithHttpInfo(OffsetDateTime startHr, GetUsageNetworkFlowsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageNetworkFlows");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/network_flows";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageNetworkFlows");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageNetworkFlowsResponse> localVarReturnType = new GenericType<UsageNetworkFlowsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageNetworkFlows", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageNetworkHostsResponse getUsageNetworkHosts(OffsetDateTime startHr) throws ApiException {
        return this.getUsageNetworkHostsWithHttpInfo(startHr, new GetUsageNetworkHostsOptionalParameters()).getData();
    }

    public UsageNetworkHostsResponse getUsageNetworkHosts(OffsetDateTime startHr, GetUsageNetworkHostsOptionalParameters parameters) throws ApiException {
        return this.getUsageNetworkHostsWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageNetworkHostsResponse> getUsageNetworkHostsWithHttpInfo(OffsetDateTime startHr, GetUsageNetworkHostsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageNetworkHosts");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/network_hosts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageNetworkHosts");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageNetworkHostsResponse> localVarReturnType = new GenericType<UsageNetworkHostsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageNetworkHosts", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageProfilingResponse getUsageProfiling(OffsetDateTime startHr) throws ApiException {
        return this.getUsageProfilingWithHttpInfo(startHr, new GetUsageProfilingOptionalParameters()).getData();
    }

    public UsageProfilingResponse getUsageProfiling(OffsetDateTime startHr, GetUsageProfilingOptionalParameters parameters) throws ApiException {
        return this.getUsageProfilingWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageProfilingResponse> getUsageProfilingWithHttpInfo(OffsetDateTime startHr, GetUsageProfilingOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageProfiling");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/profiling";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageProfiling");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageProfilingResponse> localVarReturnType = new GenericType<UsageProfilingResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageProfiling", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageRumSessionsResponse getUsageRumSessions(OffsetDateTime startHr) throws ApiException {
        return this.getUsageRumSessionsWithHttpInfo(startHr, new GetUsageRumSessionsOptionalParameters()).getData();
    }

    public UsageRumSessionsResponse getUsageRumSessions(OffsetDateTime startHr, GetUsageRumSessionsOptionalParameters parameters) throws ApiException {
        return this.getUsageRumSessionsWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageRumSessionsResponse> getUsageRumSessionsWithHttpInfo(OffsetDateTime startHr, GetUsageRumSessionsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageRumSessions");
        }
        OffsetDateTime endHr = parameters.endHr;
        String type = parameters.type;
        String localVarPath = "/api/v1/usage/rum_sessions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "type", type));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageRumSessions");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageRumSessionsResponse> localVarReturnType = new GenericType<UsageRumSessionsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageRumSessions", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageRumUnitsResponse getUsageRumUnits(OffsetDateTime startHr) throws ApiException {
        return this.getUsageRumUnitsWithHttpInfo(startHr, new GetUsageRumUnitsOptionalParameters()).getData();
    }

    public UsageRumUnitsResponse getUsageRumUnits(OffsetDateTime startHr, GetUsageRumUnitsOptionalParameters parameters) throws ApiException {
        return this.getUsageRumUnitsWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageRumUnitsResponse> getUsageRumUnitsWithHttpInfo(OffsetDateTime startHr, GetUsageRumUnitsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageRumUnits");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/rum";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageRumUnits");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageRumUnitsResponse> localVarReturnType = new GenericType<UsageRumUnitsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageRumUnits", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageSDSResponse getUsageSDS(OffsetDateTime startHr) throws ApiException {
        return this.getUsageSDSWithHttpInfo(startHr, new GetUsageSDSOptionalParameters()).getData();
    }

    public UsageSDSResponse getUsageSDS(OffsetDateTime startHr, GetUsageSDSOptionalParameters parameters) throws ApiException {
        return this.getUsageSDSWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageSDSResponse> getUsageSDSWithHttpInfo(OffsetDateTime startHr, GetUsageSDSOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageSDS");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/sds";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageSDS");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSDSResponse> localVarReturnType = new GenericType<UsageSDSResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageSDS", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageSNMPResponse getUsageSNMP(OffsetDateTime startHr) throws ApiException {
        return this.getUsageSNMPWithHttpInfo(startHr, new GetUsageSNMPOptionalParameters()).getData();
    }

    public UsageSNMPResponse getUsageSNMP(OffsetDateTime startHr, GetUsageSNMPOptionalParameters parameters) throws ApiException {
        return this.getUsageSNMPWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageSNMPResponse> getUsageSNMPWithHttpInfo(OffsetDateTime startHr, GetUsageSNMPOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageSNMP");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/snmp";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageSNMP");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSNMPResponse> localVarReturnType = new GenericType<UsageSNMPResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageSNMP", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageSummaryResponse getUsageSummary(OffsetDateTime startMonth) throws ApiException {
        return this.getUsageSummaryWithHttpInfo(startMonth, new GetUsageSummaryOptionalParameters()).getData();
    }

    public UsageSummaryResponse getUsageSummary(OffsetDateTime startMonth, GetUsageSummaryOptionalParameters parameters) throws ApiException {
        return this.getUsageSummaryWithHttpInfo(startMonth, parameters).getData();
    }

    public ApiResponse<UsageSummaryResponse> getUsageSummaryWithHttpInfo(OffsetDateTime startMonth, GetUsageSummaryOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startMonth == null) {
            throw new ApiException(400, "Missing the required parameter 'startMonth' when calling getUsageSummary");
        }
        OffsetDateTime endMonth = parameters.endMonth;
        Boolean includeOrgDetails = parameters.includeOrgDetails;
        String localVarPath = "/api/v1/usage/summary";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_month", startMonth));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_month", endMonth));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_org_details", includeOrgDetails));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageSummary");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSummaryResponse> localVarReturnType = new GenericType<UsageSummaryResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageSummary", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    @Deprecated
    public UsageSyntheticsResponse getUsageSynthetics(OffsetDateTime startHr) throws ApiException {
        return this.getUsageSyntheticsWithHttpInfo(startHr, new GetUsageSyntheticsOptionalParameters()).getData();
    }

    @Deprecated
    public UsageSyntheticsResponse getUsageSynthetics(OffsetDateTime startHr, GetUsageSyntheticsOptionalParameters parameters) throws ApiException {
        return this.getUsageSyntheticsWithHttpInfo(startHr, parameters).getData();
    }

    @Deprecated
    public ApiResponse<UsageSyntheticsResponse> getUsageSyntheticsWithHttpInfo(OffsetDateTime startHr, GetUsageSyntheticsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageSynthetics");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/synthetics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageSynthetics");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSyntheticsResponse> localVarReturnType = new GenericType<UsageSyntheticsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageSynthetics", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageSyntheticsAPIResponse getUsageSyntheticsAPI(OffsetDateTime startHr) throws ApiException {
        return this.getUsageSyntheticsAPIWithHttpInfo(startHr, new GetUsageSyntheticsAPIOptionalParameters()).getData();
    }

    public UsageSyntheticsAPIResponse getUsageSyntheticsAPI(OffsetDateTime startHr, GetUsageSyntheticsAPIOptionalParameters parameters) throws ApiException {
        return this.getUsageSyntheticsAPIWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageSyntheticsAPIResponse> getUsageSyntheticsAPIWithHttpInfo(OffsetDateTime startHr, GetUsageSyntheticsAPIOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageSyntheticsAPI");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/synthetics_api";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageSyntheticsAPI");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSyntheticsAPIResponse> localVarReturnType = new GenericType<UsageSyntheticsAPIResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageSyntheticsAPI", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageSyntheticsBrowserResponse getUsageSyntheticsBrowser(OffsetDateTime startHr) throws ApiException {
        return this.getUsageSyntheticsBrowserWithHttpInfo(startHr, new GetUsageSyntheticsBrowserOptionalParameters()).getData();
    }

    public UsageSyntheticsBrowserResponse getUsageSyntheticsBrowser(OffsetDateTime startHr, GetUsageSyntheticsBrowserOptionalParameters parameters) throws ApiException {
        return this.getUsageSyntheticsBrowserWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageSyntheticsBrowserResponse> getUsageSyntheticsBrowserWithHttpInfo(OffsetDateTime startHr, GetUsageSyntheticsBrowserOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageSyntheticsBrowser");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/synthetics_browser";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageSyntheticsBrowser");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSyntheticsBrowserResponse> localVarReturnType = new GenericType<UsageSyntheticsBrowserResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageSyntheticsBrowser", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageTimeseriesResponse getUsageTimeseries(OffsetDateTime startHr) throws ApiException {
        return this.getUsageTimeseriesWithHttpInfo(startHr, new GetUsageTimeseriesOptionalParameters()).getData();
    }

    public UsageTimeseriesResponse getUsageTimeseries(OffsetDateTime startHr, GetUsageTimeseriesOptionalParameters parameters) throws ApiException {
        return this.getUsageTimeseriesWithHttpInfo(startHr, parameters).getData();
    }

    public ApiResponse<UsageTimeseriesResponse> getUsageTimeseriesWithHttpInfo(OffsetDateTime startHr, GetUsageTimeseriesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageTimeseries");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v1/usage/timeseries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageTimeseries");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageTimeseriesResponse> localVarReturnType = new GenericType<UsageTimeseriesResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageTimeseries", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UsageTopAvgMetricsResponse getUsageTopAvgMetrics() throws ApiException {
        return this.getUsageTopAvgMetricsWithHttpInfo(new GetUsageTopAvgMetricsOptionalParameters()).getData();
    }

    public UsageTopAvgMetricsResponse getUsageTopAvgMetrics(GetUsageTopAvgMetricsOptionalParameters parameters) throws ApiException {
        return this.getUsageTopAvgMetricsWithHttpInfo(parameters).getData();
    }

    public ApiResponse<UsageTopAvgMetricsResponse> getUsageTopAvgMetricsWithHttpInfo(GetUsageTopAvgMetricsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        OffsetDateTime month = parameters.month;
        OffsetDateTime day = parameters.day;
        List names = parameters.names;
        Integer limit = parameters.limit;
        String nextRecordId = parameters.nextRecordId;
        String localVarPath = "/api/v1/usage/top_avg_metrics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "month", month));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "day", day));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "names", names));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "next_record_id", nextRecordId));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageTopAvgMetrics");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<UsageTopAvgMetricsResponse> localVarReturnType = new GenericType<UsageTopAvgMetricsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageTopAvgMetrics", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public static class GetUsageTopAvgMetricsOptionalParameters {
        private OffsetDateTime month;
        private OffsetDateTime day;
        private List<String> names;
        private Integer limit;
        private String nextRecordId;

        public GetUsageTopAvgMetricsOptionalParameters month(OffsetDateTime month) {
            this.month = month;
            return this;
        }

        public GetUsageTopAvgMetricsOptionalParameters day(OffsetDateTime day) {
            this.day = day;
            return this;
        }

        public GetUsageTopAvgMetricsOptionalParameters names(List<String> names) {
            this.names = names;
            return this;
        }

        public GetUsageTopAvgMetricsOptionalParameters limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetUsageTopAvgMetricsOptionalParameters nextRecordId(String nextRecordId) {
            this.nextRecordId = nextRecordId;
            return this;
        }
    }

    public static class GetUsageTimeseriesOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageTimeseriesOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageSyntheticsBrowserOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageSyntheticsBrowserOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageSyntheticsAPIOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageSyntheticsAPIOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageSyntheticsOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageSyntheticsOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageSummaryOptionalParameters {
        private OffsetDateTime endMonth;
        private Boolean includeOrgDetails;

        public GetUsageSummaryOptionalParameters endMonth(OffsetDateTime endMonth) {
            this.endMonth = endMonth;
            return this;
        }

        public GetUsageSummaryOptionalParameters includeOrgDetails(Boolean includeOrgDetails) {
            this.includeOrgDetails = includeOrgDetails;
            return this;
        }
    }

    public static class GetUsageSNMPOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageSNMPOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageSDSOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageSDSOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageRumUnitsOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageRumUnitsOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageRumSessionsOptionalParameters {
        private OffsetDateTime endHr;
        private String type;

        public GetUsageRumSessionsOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public GetUsageRumSessionsOptionalParameters type(String type) {
            this.type = type;
            return this;
        }
    }

    public static class GetUsageProfilingOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageProfilingOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageNetworkHostsOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageNetworkHostsOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageNetworkFlowsOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageNetworkFlowsOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageLogsByRetentionOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageLogsByRetentionOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageLogsByIndexOptionalParameters {
        private OffsetDateTime endHr;
        private List<String> indexName;

        public GetUsageLogsByIndexOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public GetUsageLogsByIndexOptionalParameters indexName(List<String> indexName) {
            this.indexName = indexName;
            return this;
        }
    }

    public static class GetUsageLogsOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageLogsOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageLambdaOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageLambdaOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageInternetOfThingsOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageInternetOfThingsOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageIndexedSpansOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageIndexedSpansOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageHostsOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageHostsOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageFargateOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageFargateOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageDBMOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageDBMOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageCloudSecurityPostureManagementOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageCloudSecurityPostureManagementOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageCWSOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageCWSOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageBillableSummaryOptionalParameters {
        private OffsetDateTime month;

        public GetUsageBillableSummaryOptionalParameters month(OffsetDateTime month) {
            this.month = month;
            return this;
        }
    }

    public static class GetUsageAuditLogsOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageAuditLogsOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageAttributionOptionalParameters {
        private OffsetDateTime endMonth;
        private UsageSortDirection sortDirection;
        private UsageAttributionSort sortName;
        private Boolean includeDescendants;
        private Long offset;
        private Long limit;

        public GetUsageAttributionOptionalParameters endMonth(OffsetDateTime endMonth) {
            this.endMonth = endMonth;
            return this;
        }

        public GetUsageAttributionOptionalParameters sortDirection(UsageSortDirection sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        public GetUsageAttributionOptionalParameters sortName(UsageAttributionSort sortName) {
            this.sortName = sortName;
            return this;
        }

        public GetUsageAttributionOptionalParameters includeDescendants(Boolean includeDescendants) {
            this.includeDescendants = includeDescendants;
            return this;
        }

        public GetUsageAttributionOptionalParameters offset(Long offset) {
            this.offset = offset;
            return this;
        }

        public GetUsageAttributionOptionalParameters limit(Long limit) {
            this.limit = limit;
            return this;
        }
    }

    public static class GetUsageAnalyzedLogsOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageAnalyzedLogsOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetMonthlyUsageAttributionOptionalParameters {
        private OffsetDateTime endMonth;
        private UsageSortDirection sortDirection;
        private MonthlyUsageAttributionSupportedMetrics sortName;
        private String tagBreakdownKeys;
        private String nextRecordId;

        public GetMonthlyUsageAttributionOptionalParameters endMonth(OffsetDateTime endMonth) {
            this.endMonth = endMonth;
            return this;
        }

        public GetMonthlyUsageAttributionOptionalParameters sortDirection(UsageSortDirection sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        public GetMonthlyUsageAttributionOptionalParameters sortName(MonthlyUsageAttributionSupportedMetrics sortName) {
            this.sortName = sortName;
            return this;
        }

        public GetMonthlyUsageAttributionOptionalParameters tagBreakdownKeys(String tagBreakdownKeys) {
            this.tagBreakdownKeys = tagBreakdownKeys;
            return this;
        }

        public GetMonthlyUsageAttributionOptionalParameters nextRecordId(String nextRecordId) {
            this.nextRecordId = nextRecordId;
            return this;
        }
    }

    public static class GetMonthlyCustomReportsOptionalParameters {
        private Long pageSize;
        private Long pageNumber;
        private UsageSortDirection sortDir;
        private UsageSort sort;

        public GetMonthlyCustomReportsOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetMonthlyCustomReportsOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public GetMonthlyCustomReportsOptionalParameters sortDir(UsageSortDirection sortDir) {
            this.sortDir = sortDir;
            return this;
        }

        public GetMonthlyCustomReportsOptionalParameters sort(UsageSort sort) {
            this.sort = sort;
            return this;
        }
    }

    public static class GetIngestedSpansOptionalParameters {
        private OffsetDateTime endHr;

        public GetIngestedSpansOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetIncidentManagementOptionalParameters {
        private OffsetDateTime endHr;

        public GetIncidentManagementOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetHourlyUsageAttributionOptionalParameters {
        private OffsetDateTime endHr;
        private String nextRecordId;
        private String tagBreakdownKeys;

        public GetHourlyUsageAttributionOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public GetHourlyUsageAttributionOptionalParameters nextRecordId(String nextRecordId) {
            this.nextRecordId = nextRecordId;
            return this;
        }

        public GetHourlyUsageAttributionOptionalParameters tagBreakdownKeys(String tagBreakdownKeys) {
            this.tagBreakdownKeys = tagBreakdownKeys;
            return this;
        }
    }

    public static class GetDailyCustomReportsOptionalParameters {
        private Long pageSize;
        private Long pageNumber;
        private UsageSortDirection sortDir;
        private UsageSort sort;

        public GetDailyCustomReportsOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetDailyCustomReportsOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public GetDailyCustomReportsOptionalParameters sortDir(UsageSortDirection sortDir) {
            this.sortDir = sortDir;
            return this;
        }

        public GetDailyCustomReportsOptionalParameters sort(UsageSort sort) {
            this.sort = sort;
            return this;
        }
    }
}

