/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.SecurityMonitoringRuleDetectionMethod;
import com.datadog.api.v2.client.model.SecurityMonitoringRuleEvaluationWindow;
import com.datadog.api.v2.client.model.SecurityMonitoringRuleKeepAlive;
import com.datadog.api.v2.client.model.SecurityMonitoringRuleMaxSignalDuration;
import com.datadog.api.v2.client.model.SecurityMonitoringRuleNewValueOptions;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Options on rules.")
@JsonPropertyOrder(value={"detectionMethod", "evaluationWindow", "keepAlive", "maxSignalDuration", "newValueOptions"})
public class SecurityMonitoringRuleOptions {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DETECTION_METHOD = "detectionMethod";
    private SecurityMonitoringRuleDetectionMethod detectionMethod;
    public static final String JSON_PROPERTY_EVALUATION_WINDOW = "evaluationWindow";
    private SecurityMonitoringRuleEvaluationWindow evaluationWindow;
    public static final String JSON_PROPERTY_KEEP_ALIVE = "keepAlive";
    private SecurityMonitoringRuleKeepAlive keepAlive;
    public static final String JSON_PROPERTY_MAX_SIGNAL_DURATION = "maxSignalDuration";
    private SecurityMonitoringRuleMaxSignalDuration maxSignalDuration;
    public static final String JSON_PROPERTY_NEW_VALUE_OPTIONS = "newValueOptions";
    private SecurityMonitoringRuleNewValueOptions newValueOptions;

    public SecurityMonitoringRuleOptions detectionMethod(SecurityMonitoringRuleDetectionMethod detectionMethod) {
        this.detectionMethod = detectionMethod;
        this.unparsed |= !detectionMethod.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="detectionMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleDetectionMethod getDetectionMethod() {
        return this.detectionMethod;
    }

    public void setDetectionMethod(SecurityMonitoringRuleDetectionMethod detectionMethod) {
        if (!detectionMethod.isValid()) {
            this.unparsed = true;
        }
        this.detectionMethod = detectionMethod;
    }

    public SecurityMonitoringRuleOptions evaluationWindow(SecurityMonitoringRuleEvaluationWindow evaluationWindow) {
        this.evaluationWindow = evaluationWindow;
        this.unparsed |= !evaluationWindow.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="evaluationWindow")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleEvaluationWindow getEvaluationWindow() {
        return this.evaluationWindow;
    }

    public void setEvaluationWindow(SecurityMonitoringRuleEvaluationWindow evaluationWindow) {
        if (!evaluationWindow.isValid()) {
            this.unparsed = true;
        }
        this.evaluationWindow = evaluationWindow;
    }

    public SecurityMonitoringRuleOptions keepAlive(SecurityMonitoringRuleKeepAlive keepAlive) {
        this.keepAlive = keepAlive;
        this.unparsed |= !keepAlive.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="keepAlive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleKeepAlive getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(SecurityMonitoringRuleKeepAlive keepAlive) {
        if (!keepAlive.isValid()) {
            this.unparsed = true;
        }
        this.keepAlive = keepAlive;
    }

    public SecurityMonitoringRuleOptions maxSignalDuration(SecurityMonitoringRuleMaxSignalDuration maxSignalDuration) {
        this.maxSignalDuration = maxSignalDuration;
        this.unparsed |= !maxSignalDuration.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="maxSignalDuration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleMaxSignalDuration getMaxSignalDuration() {
        return this.maxSignalDuration;
    }

    public void setMaxSignalDuration(SecurityMonitoringRuleMaxSignalDuration maxSignalDuration) {
        if (!maxSignalDuration.isValid()) {
            this.unparsed = true;
        }
        this.maxSignalDuration = maxSignalDuration;
    }

    public SecurityMonitoringRuleOptions newValueOptions(SecurityMonitoringRuleNewValueOptions newValueOptions) {
        this.newValueOptions = newValueOptions;
        this.unparsed |= newValueOptions.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="newValueOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleNewValueOptions getNewValueOptions() {
        return this.newValueOptions;
    }

    public void setNewValueOptions(SecurityMonitoringRuleNewValueOptions newValueOptions) {
        this.newValueOptions = newValueOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityMonitoringRuleOptions securityMonitoringRuleOptions = (SecurityMonitoringRuleOptions)o;
        return Objects.equals(this.detectionMethod, securityMonitoringRuleOptions.detectionMethod) && Objects.equals(this.evaluationWindow, securityMonitoringRuleOptions.evaluationWindow) && Objects.equals(this.keepAlive, securityMonitoringRuleOptions.keepAlive) && Objects.equals(this.maxSignalDuration, securityMonitoringRuleOptions.maxSignalDuration) && Objects.equals(this.newValueOptions, securityMonitoringRuleOptions.newValueOptions);
    }

    public int hashCode() {
        return Objects.hash(this.detectionMethod, this.evaluationWindow, this.keepAlive, this.maxSignalDuration, this.newValueOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityMonitoringRuleOptions {\n");
        sb.append("    detectionMethod: ").append(this.toIndentedString(this.detectionMethod)).append("\n");
        sb.append("    evaluationWindow: ").append(this.toIndentedString(this.evaluationWindow)).append("\n");
        sb.append("    keepAlive: ").append(this.toIndentedString(this.keepAlive)).append("\n");
        sb.append("    maxSignalDuration: ").append(this.toIndentedString(this.maxSignalDuration)).append("\n");
        sb.append("    newValueOptions: ").append(this.toIndentedString(this.newValueOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

