/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.JSON;
import com.datadog.api.v2.client.model.AbstractOpenApiSchema;
import com.datadog.api.v2.client.model.Metric;
import com.datadog.api.v2.client.model.MetricTagConfiguration;
import com.datadog.api.v2.client.model.UnparsedObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;

@JsonDeserialize(using=MetricsAndMetricTagConfigurationsDeserializer.class)
@JsonSerialize(using=MetricsAndMetricTagConfigurationsSerializer.class)
public class MetricsAndMetricTagConfigurations
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(MetricsAndMetricTagConfigurations.class.getName());
    @JsonIgnore
    public boolean unparsed = false;
    public static final Map<String, GenericType> schemas = new HashMap<String, GenericType>();

    public MetricsAndMetricTagConfigurations() {
        super("oneOf", Boolean.FALSE);
    }

    public MetricsAndMetricTagConfigurations(Metric o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public MetricsAndMetricTagConfigurations(MetricTagConfiguration o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, GenericType> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (JSON.isInstanceOf(Metric.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(MetricTagConfiguration.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(UnparsedObject.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be Metric, MetricTagConfiguration");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public Metric getMetric() throws ClassCastException {
        return (Metric)super.getActualInstance();
    }

    public MetricTagConfiguration getMetricTagConfiguration() throws ClassCastException {
        return (MetricTagConfiguration)super.getActualInstance();
    }

    static {
        schemas.put("Metric", (GenericType)new GenericType<Metric>(){});
        schemas.put("MetricTagConfiguration", (GenericType)new GenericType<MetricTagConfiguration>(){});
        JSON.registerDescendants(MetricsAndMetricTagConfigurations.class, Collections.unmodifiableMap(schemas));
    }

    public static class MetricsAndMetricTagConfigurationsDeserializer
    extends StdDeserializer<MetricsAndMetricTagConfigurations> {
        public MetricsAndMetricTagConfigurationsDeserializer() {
            this(MetricsAndMetricTagConfigurations.class);
        }

        public MetricsAndMetricTagConfigurationsDeserializer(Class<?> vc) {
            super(vc);
        }

        public MetricsAndMetricTagConfigurations deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            Object deserialized = null;
            Object tmp = null;
            boolean typeCoercion = ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS);
            int match = 0;
            JsonToken token = tree.traverse(jp.getCodec()).nextToken();
            try {
                boolean attemptParsing = true;
                if ((Metric.class.equals(Integer.class) || Metric.class.equals(Long.class) || Metric.class.equals(Float.class) || Metric.class.equals(Double.class) || Metric.class.equals(Boolean.class) || Metric.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (Metric.class.equals(Integer.class) || Metric.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= !(!Metric.class.equals(Float.class) && !Metric.class.equals(Double.class) || token != JsonToken.VALUE_NUMBER_FLOAT && token != JsonToken.VALUE_NUMBER_INT);
                    attemptParsing |= Metric.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= Metric.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                if (attemptParsing) {
                    tmp = tree.traverse(jp.getCodec()).readValueAs(Metric.class);
                    if (!((Metric)tmp).unparsed) {
                        deserialized = tmp;
                        ++match;
                    }
                    log.log(Level.FINER, "Input data matches schema 'Metric'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'Metric'", e);
            }
            try {
                boolean attemptParsing = true;
                if ((MetricTagConfiguration.class.equals(Integer.class) || MetricTagConfiguration.class.equals(Long.class) || MetricTagConfiguration.class.equals(Float.class) || MetricTagConfiguration.class.equals(Double.class) || MetricTagConfiguration.class.equals(Boolean.class) || MetricTagConfiguration.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (MetricTagConfiguration.class.equals(Integer.class) || MetricTagConfiguration.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= !(!MetricTagConfiguration.class.equals(Float.class) && !MetricTagConfiguration.class.equals(Double.class) || token != JsonToken.VALUE_NUMBER_FLOAT && token != JsonToken.VALUE_NUMBER_INT);
                    attemptParsing |= MetricTagConfiguration.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= MetricTagConfiguration.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                if (attemptParsing) {
                    tmp = tree.traverse(jp.getCodec()).readValueAs(MetricTagConfiguration.class);
                    if (!((MetricTagConfiguration)tmp).unparsed) {
                        deserialized = tmp;
                        ++match;
                    }
                    log.log(Level.FINER, "Input data matches schema 'MetricTagConfiguration'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'MetricTagConfiguration'", e);
            }
            MetricsAndMetricTagConfigurations ret = new MetricsAndMetricTagConfigurations();
            if (match == 1) {
                ret.setActualInstance(deserialized);
            } else {
                Map res = (Map)new ObjectMapper().readValue(tree.traverse(jp.getCodec()).readValueAsTree().toString(), HashMap.class);
                ret.setActualInstance(new UnparsedObject(res));
            }
            return ret;
        }

        public MetricsAndMetricTagConfigurations getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "MetricsAndMetricTagConfigurations cannot be null");
        }
    }

    public static class MetricsAndMetricTagConfigurationsSerializer
    extends StdSerializer<MetricsAndMetricTagConfigurations> {
        public MetricsAndMetricTagConfigurationsSerializer(Class<MetricsAndMetricTagConfigurations> t) {
            super(t);
        }

        public MetricsAndMetricTagConfigurationsSerializer() {
            this(null);
        }

        public void serialize(MetricsAndMetricTagConfigurations value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getActualInstance());
        }
    }
}

