/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object containing the definition of a metric's tags.")
@JsonPropertyOrder(value={"tags"})
public class MetricAllTagsAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;

    public MetricAllTagsAttributes tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public MetricAllTagsAttributes addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"sport:golf\",\"sport:football\",\"animal:dog\"]", value="List of indexed tag value pairs.")
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricAllTagsAttributes metricAllTagsAttributes = (MetricAllTagsAttributes)o;
        return Objects.equals(this.tags, metricAllTagsAttributes.tags);
    }

    public int hashCode() {
        return Objects.hash(this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricAllTagsAttributes {\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

