/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.LogsMetricResponseData;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="All the available log-based metric objects.")
@JsonPropertyOrder(value={"data"})
public class LogsMetricsResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATA = "data";
    private List<LogsMetricResponseData> data = null;

    public LogsMetricsResponse data(List<LogsMetricResponseData> data) {
        this.data = data;
        for (LogsMetricResponseData item : data) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public LogsMetricsResponse addDataItem(LogsMetricResponseData dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<LogsMetricResponseData>();
        }
        this.data.add(dataItem);
        this.unparsed |= dataItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of log-based metric objects.")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LogsMetricResponseData> getData() {
        return this.data;
    }

    public void setData(List<LogsMetricResponseData> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsMetricsResponse logsMetricsResponse = (LogsMetricsResponse)o;
        return Objects.equals(this.data, logsMetricsResponse.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsMetricsResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

