/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The S3 Archive's integration destination.")
@JsonPropertyOrder(value={"account_id", "role_name"})
public class LogsArchiveIntegrationS3 {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ACCOUNT_ID = "account_id";
    private String accountId;
    public static final String JSON_PROPERTY_ROLE_NAME = "role_name";
    private String roleName;

    public LogsArchiveIntegrationS3() {
    }

    @JsonCreator
    public LogsArchiveIntegrationS3(@JsonProperty(required=true, value="account_id") String accountId, @JsonProperty(required=true, value="role_name") String roleName) {
        this.accountId = accountId;
        this.roleName = roleName;
    }

    public LogsArchiveIntegrationS3 accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(example="123456789012", required=true, value="The account ID for the integration.")
    @JsonProperty(value="account_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public LogsArchiveIntegrationS3 roleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    @ApiModelProperty(example="role-name", required=true, value="The path of the integration.")
    @JsonProperty(value="role_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsArchiveIntegrationS3 logsArchiveIntegrationS3 = (LogsArchiveIntegrationS3)o;
        return Objects.equals(this.accountId, logsArchiveIntegrationS3.accountId) && Objects.equals(this.roleName, logsArchiveIntegrationS3.roleName);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.roleName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsArchiveIntegrationS3 {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    roleName: ").append(this.toIndentedString(this.roleName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

