/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.UsageTopAvgMetricsHour;
import com.datadog.api.v1.client.model.UsageTopAvgMetricsMetadata;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Response containing the number of hourly recorded custom metrics for a given organization.")
@JsonPropertyOrder(value={"metadata", "usage"})
public class UsageTopAvgMetricsResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private UsageTopAvgMetricsMetadata metadata;
    public static final String JSON_PROPERTY_USAGE = "usage";
    private List<UsageTopAvgMetricsHour> usage = null;

    public UsageTopAvgMetricsResponse metadata(UsageTopAvgMetricsMetadata metadata) {
        this.metadata = metadata;
        this.unparsed |= metadata.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UsageTopAvgMetricsMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(UsageTopAvgMetricsMetadata metadata) {
        this.metadata = metadata;
    }

    public UsageTopAvgMetricsResponse usage(List<UsageTopAvgMetricsHour> usage) {
        this.usage = usage;
        for (UsageTopAvgMetricsHour item : usage) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public UsageTopAvgMetricsResponse addUsageItem(UsageTopAvgMetricsHour usageItem) {
        if (this.usage == null) {
            this.usage = new ArrayList<UsageTopAvgMetricsHour>();
        }
        this.usage.add(usageItem);
        this.unparsed |= usageItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of hourly recorded custom metrics for a given organization.")
    @JsonProperty(value="usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UsageTopAvgMetricsHour> getUsage() {
        return this.usage;
    }

    public void setUsage(List<UsageTopAvgMetricsHour> usage) {
        this.usage = usage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageTopAvgMetricsResponse usageTopAvgMetricsResponse = (UsageTopAvgMetricsResponse)o;
        return Objects.equals(this.metadata, usageTopAvgMetricsResponse.metadata) && Objects.equals(this.usage, usageTopAvgMetricsResponse.usage);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.usage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageTopAvgMetricsResponse {\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    usage: ").append(this.toIndentedString(this.usage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

