/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=TargetFormatTypeSerializer.class)
public class TargetFormatType {
    public static final TargetFormatType AUTO = new TargetFormatType("auto");
    public static final TargetFormatType STRING = new TargetFormatType("string");
    public static final TargetFormatType INTEGER = new TargetFormatType("integer");
    public static final TargetFormatType DOUBLE = new TargetFormatType("double");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("auto", "string", "integer", "double"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    TargetFormatType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((TargetFormatType)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static TargetFormatType fromValue(String value) {
        return new TargetFormatType(value);
    }

    public static class TargetFormatTypeSerializer
    extends StdSerializer<TargetFormatType> {
        public TargetFormatTypeSerializer(Class<TargetFormatType> t) {
            super(t);
        }

        public TargetFormatTypeSerializer() {
            this(null);
        }

        public void serialize(TargetFormatType value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

