/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SyntheticsDeviceID;
import com.datadog.api.v1.client.model.SyntheticsTestOptionsMonitorOptions;
import com.datadog.api.v1.client.model.SyntheticsTestOptionsRetry;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object describing the extra options for a Synthetic test.")
@JsonPropertyOrder(value={"accept_self_signed", "allow_insecure", "device_ids", "disableCors", "follow_redirects", "min_failure_duration", "min_location_failed", "monitor_name", "monitor_options", "monitor_priority", "noScreenshot", "retry", "tick_every"})
public class SyntheticsTestOptions {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ACCEPT_SELF_SIGNED = "accept_self_signed";
    private Boolean acceptSelfSigned;
    public static final String JSON_PROPERTY_ALLOW_INSECURE = "allow_insecure";
    private Boolean allowInsecure;
    public static final String JSON_PROPERTY_DEVICE_IDS = "device_ids";
    private List<SyntheticsDeviceID> deviceIds = null;
    public static final String JSON_PROPERTY_DISABLE_CORS = "disableCors";
    private Boolean disableCors;
    public static final String JSON_PROPERTY_FOLLOW_REDIRECTS = "follow_redirects";
    private Boolean followRedirects;
    public static final String JSON_PROPERTY_MIN_FAILURE_DURATION = "min_failure_duration";
    private Long minFailureDuration;
    public static final String JSON_PROPERTY_MIN_LOCATION_FAILED = "min_location_failed";
    private Long minLocationFailed;
    public static final String JSON_PROPERTY_MONITOR_NAME = "monitor_name";
    private String monitorName;
    public static final String JSON_PROPERTY_MONITOR_OPTIONS = "monitor_options";
    private SyntheticsTestOptionsMonitorOptions monitorOptions;
    public static final String JSON_PROPERTY_MONITOR_PRIORITY = "monitor_priority";
    private Integer monitorPriority;
    public static final String JSON_PROPERTY_NO_SCREENSHOT = "noScreenshot";
    private Boolean noScreenshot;
    public static final String JSON_PROPERTY_RETRY = "retry";
    private SyntheticsTestOptionsRetry retry;
    public static final String JSON_PROPERTY_TICK_EVERY = "tick_every";
    private Long tickEvery;

    public SyntheticsTestOptions acceptSelfSigned(Boolean acceptSelfSigned) {
        this.acceptSelfSigned = acceptSelfSigned;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For SSL test, whether or not the test should allow self signed certificates.")
    @JsonProperty(value="accept_self_signed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAcceptSelfSigned() {
        return this.acceptSelfSigned;
    }

    public void setAcceptSelfSigned(Boolean acceptSelfSigned) {
        this.acceptSelfSigned = acceptSelfSigned;
    }

    public SyntheticsTestOptions allowInsecure(Boolean allowInsecure) {
        this.allowInsecure = allowInsecure;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allows loading insecure content for an HTTP request.")
    @JsonProperty(value="allow_insecure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowInsecure() {
        return this.allowInsecure;
    }

    public void setAllowInsecure(Boolean allowInsecure) {
        this.allowInsecure = allowInsecure;
    }

    public SyntheticsTestOptions deviceIds(List<SyntheticsDeviceID> deviceIds) {
        this.deviceIds = deviceIds;
        return this;
    }

    public SyntheticsTestOptions addDeviceIdsItem(SyntheticsDeviceID deviceIdsItem) {
        if (this.deviceIds == null) {
            this.deviceIds = new ArrayList<SyntheticsDeviceID>();
        }
        this.deviceIds.add(deviceIdsItem);
        this.unparsed |= !deviceIdsItem.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For browser test, array with the different device IDs used to run the test.")
    @JsonProperty(value="device_ids")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsDeviceID> getDeviceIds() {
        return this.deviceIds;
    }

    public void setDeviceIds(List<SyntheticsDeviceID> deviceIds) {
        this.deviceIds = deviceIds;
    }

    public SyntheticsTestOptions disableCors(Boolean disableCors) {
        this.disableCors = disableCors;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not to disable CORS mechanism.")
    @JsonProperty(value="disableCors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDisableCors() {
        return this.disableCors;
    }

    public void setDisableCors(Boolean disableCors) {
        this.disableCors = disableCors;
    }

    public SyntheticsTestOptions followRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For API HTTP test, whether or not the test should follow redirects.")
    @JsonProperty(value="follow_redirects")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public SyntheticsTestOptions minFailureDuration(Long minFailureDuration) {
        this.minFailureDuration = minFailureDuration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Minimum amount of time in failure required to trigger an alert.")
    @JsonProperty(value="min_failure_duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMinFailureDuration() {
        return this.minFailureDuration;
    }

    public void setMinFailureDuration(Long minFailureDuration) {
        this.minFailureDuration = minFailureDuration;
    }

    public SyntheticsTestOptions minLocationFailed(Long minLocationFailed) {
        this.minLocationFailed = minLocationFailed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Minimum number of locations in failure required to trigger an alert.")
    @JsonProperty(value="min_location_failed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMinLocationFailed() {
        return this.minLocationFailed;
    }

    public void setMinLocationFailed(Long minLocationFailed) {
        this.minLocationFailed = minLocationFailed;
    }

    public SyntheticsTestOptions monitorName(String monitorName) {
        this.monitorName = monitorName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The monitor name is used for the alert title as well as for all monitor dashboard widgets and SLOs.")
    @JsonProperty(value="monitor_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMonitorName() {
        return this.monitorName;
    }

    public void setMonitorName(String monitorName) {
        this.monitorName = monitorName;
    }

    public SyntheticsTestOptions monitorOptions(SyntheticsTestOptionsMonitorOptions monitorOptions) {
        this.monitorOptions = monitorOptions;
        this.unparsed |= monitorOptions.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="monitor_options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestOptionsMonitorOptions getMonitorOptions() {
        return this.monitorOptions;
    }

    public void setMonitorOptions(SyntheticsTestOptionsMonitorOptions monitorOptions) {
        this.monitorOptions = monitorOptions;
    }

    public SyntheticsTestOptions monitorPriority(Integer monitorPriority) {
        this.monitorPriority = monitorPriority;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Integer from 1 (high) to 5 (low) indicating alert severity.")
    @JsonProperty(value="monitor_priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMonitorPriority() {
        return this.monitorPriority;
    }

    public void setMonitorPriority(Integer monitorPriority) {
        this.monitorPriority = monitorPriority;
    }

    public SyntheticsTestOptions noScreenshot(Boolean noScreenshot) {
        this.noScreenshot = noScreenshot;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Prevents saving screenshots of the steps.")
    @JsonProperty(value="noScreenshot")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getNoScreenshot() {
        return this.noScreenshot;
    }

    public void setNoScreenshot(Boolean noScreenshot) {
        this.noScreenshot = noScreenshot;
    }

    public SyntheticsTestOptions retry(SyntheticsTestOptionsRetry retry) {
        this.retry = retry;
        this.unparsed |= retry.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="retry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestOptionsRetry getRetry() {
        return this.retry;
    }

    public void setRetry(SyntheticsTestOptionsRetry retry) {
        this.retry = retry;
    }

    public SyntheticsTestOptions tickEvery(Long tickEvery) {
        this.tickEvery = tickEvery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The frequency at which to run the Synthetic test (in seconds).")
    @JsonProperty(value="tick_every")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTickEvery() {
        return this.tickEvery;
    }

    public void setTickEvery(Long tickEvery) {
        this.tickEvery = tickEvery;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsTestOptions syntheticsTestOptions = (SyntheticsTestOptions)o;
        return Objects.equals(this.acceptSelfSigned, syntheticsTestOptions.acceptSelfSigned) && Objects.equals(this.allowInsecure, syntheticsTestOptions.allowInsecure) && Objects.equals(this.deviceIds, syntheticsTestOptions.deviceIds) && Objects.equals(this.disableCors, syntheticsTestOptions.disableCors) && Objects.equals(this.followRedirects, syntheticsTestOptions.followRedirects) && Objects.equals(this.minFailureDuration, syntheticsTestOptions.minFailureDuration) && Objects.equals(this.minLocationFailed, syntheticsTestOptions.minLocationFailed) && Objects.equals(this.monitorName, syntheticsTestOptions.monitorName) && Objects.equals(this.monitorOptions, syntheticsTestOptions.monitorOptions) && Objects.equals(this.monitorPriority, syntheticsTestOptions.monitorPriority) && Objects.equals(this.noScreenshot, syntheticsTestOptions.noScreenshot) && Objects.equals(this.retry, syntheticsTestOptions.retry) && Objects.equals(this.tickEvery, syntheticsTestOptions.tickEvery);
    }

    public int hashCode() {
        return Objects.hash(this.acceptSelfSigned, this.allowInsecure, this.deviceIds, this.disableCors, this.followRedirects, this.minFailureDuration, this.minLocationFailed, this.monitorName, this.monitorOptions, this.monitorPriority, this.noScreenshot, this.retry, this.tickEvery);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsTestOptions {\n");
        sb.append("    acceptSelfSigned: ").append(this.toIndentedString(this.acceptSelfSigned)).append("\n");
        sb.append("    allowInsecure: ").append(this.toIndentedString(this.allowInsecure)).append("\n");
        sb.append("    deviceIds: ").append(this.toIndentedString(this.deviceIds)).append("\n");
        sb.append("    disableCors: ").append(this.toIndentedString(this.disableCors)).append("\n");
        sb.append("    followRedirects: ").append(this.toIndentedString(this.followRedirects)).append("\n");
        sb.append("    minFailureDuration: ").append(this.toIndentedString(this.minFailureDuration)).append("\n");
        sb.append("    minLocationFailed: ").append(this.toIndentedString(this.minLocationFailed)).append("\n");
        sb.append("    monitorName: ").append(this.toIndentedString(this.monitorName)).append("\n");
        sb.append("    monitorOptions: ").append(this.toIndentedString(this.monitorOptions)).append("\n");
        sb.append("    monitorPriority: ").append(this.toIndentedString(this.monitorPriority)).append("\n");
        sb.append("    noScreenshot: ").append(this.toIndentedString(this.noScreenshot)).append("\n");
        sb.append("    retry: ").append(this.toIndentedString(this.retry)).append("\n");
        sb.append("    tickEvery: ").append(this.toIndentedString(this.tickEvery)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

