/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SyntheticsBrowserError;
import com.datadog.api.v1.client.model.SyntheticsCheckType;
import com.datadog.api.v1.client.model.SyntheticsCoreWebVitals;
import com.datadog.api.v1.client.model.SyntheticsPlayingTab;
import com.datadog.api.v1.client.model.SyntheticsStepDetailWarning;
import com.datadog.api.v1.client.model.SyntheticsStepType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object describing a step for a Synthetic test.")
@JsonPropertyOrder(value={"browserErrors", "checkType", "description", "duration", "error", "playingTab", "screenshotBucketKey", "skipped", "snapshotBucketKey", "stepId", "subTestStepDetails", "timeToInteractive", "type", "url", "value", "vitalsMetrics", "warnings"})
public class SyntheticsStepDetail {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_BROWSER_ERRORS = "browserErrors";
    private List<SyntheticsBrowserError> browserErrors = null;
    public static final String JSON_PROPERTY_CHECK_TYPE = "checkType";
    private SyntheticsCheckType checkType;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DURATION = "duration";
    private Double duration;
    public static final String JSON_PROPERTY_ERROR = "error";
    private String error;
    public static final String JSON_PROPERTY_PLAYING_TAB = "playingTab";
    private SyntheticsPlayingTab playingTab;
    public static final String JSON_PROPERTY_SCREENSHOT_BUCKET_KEY = "screenshotBucketKey";
    private Boolean screenshotBucketKey;
    public static final String JSON_PROPERTY_SKIPPED = "skipped";
    private Boolean skipped;
    public static final String JSON_PROPERTY_SNAPSHOT_BUCKET_KEY = "snapshotBucketKey";
    private Boolean snapshotBucketKey;
    public static final String JSON_PROPERTY_STEP_ID = "stepId";
    private Long stepId;
    public static final String JSON_PROPERTY_SUB_TEST_STEP_DETAILS = "subTestStepDetails";
    private List<SyntheticsStepDetail> subTestStepDetails = null;
    public static final String JSON_PROPERTY_TIME_TO_INTERACTIVE = "timeToInteractive";
    private Double timeToInteractive;
    public static final String JSON_PROPERTY_TYPE = "type";
    private SyntheticsStepType type;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    public static final String JSON_PROPERTY_VALUE = "value";
    private Object value;
    public static final String JSON_PROPERTY_VITALS_METRICS = "vitalsMetrics";
    private List<SyntheticsCoreWebVitals> vitalsMetrics = null;
    public static final String JSON_PROPERTY_WARNINGS = "warnings";
    private List<SyntheticsStepDetailWarning> warnings = null;

    public SyntheticsStepDetail browserErrors(List<SyntheticsBrowserError> browserErrors) {
        this.browserErrors = browserErrors;
        for (SyntheticsBrowserError item : browserErrors) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SyntheticsStepDetail addBrowserErrorsItem(SyntheticsBrowserError browserErrorsItem) {
        if (this.browserErrors == null) {
            this.browserErrors = new ArrayList<SyntheticsBrowserError>();
        }
        this.browserErrors.add(browserErrorsItem);
        this.unparsed |= browserErrorsItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of errors collected for a browser test.")
    @JsonProperty(value="browserErrors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsBrowserError> getBrowserErrors() {
        return this.browserErrors;
    }

    public void setBrowserErrors(List<SyntheticsBrowserError> browserErrors) {
        this.browserErrors = browserErrors;
    }

    public SyntheticsStepDetail checkType(SyntheticsCheckType checkType) {
        this.checkType = checkType;
        this.unparsed |= !checkType.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="checkType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsCheckType getCheckType() {
        return this.checkType;
    }

    public void setCheckType(SyntheticsCheckType checkType) {
        if (!checkType.isValid()) {
            this.unparsed = true;
        }
        this.checkType = checkType;
    }

    public SyntheticsStepDetail description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Description of the test.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SyntheticsStepDetail duration(Double duration) {
        this.duration = duration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total duration in millisecond of the test.")
    @JsonProperty(value="duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getDuration() {
        return this.duration;
    }

    public void setDuration(Double duration) {
        this.duration = duration;
    }

    public SyntheticsStepDetail error(String error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Error returned by the test.")
    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public SyntheticsStepDetail playingTab(SyntheticsPlayingTab playingTab) {
        this.playingTab = playingTab;
        this.unparsed |= !playingTab.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="playingTab")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsPlayingTab getPlayingTab() {
        return this.playingTab;
    }

    public void setPlayingTab(SyntheticsPlayingTab playingTab) {
        if (!playingTab.isValid()) {
            this.unparsed = true;
        }
        this.playingTab = playingTab;
    }

    public SyntheticsStepDetail screenshotBucketKey(Boolean screenshotBucketKey) {
        this.screenshotBucketKey = screenshotBucketKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not screenshots where collected by the test.")
    @JsonProperty(value="screenshotBucketKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getScreenshotBucketKey() {
        return this.screenshotBucketKey;
    }

    public void setScreenshotBucketKey(Boolean screenshotBucketKey) {
        this.screenshotBucketKey = screenshotBucketKey;
    }

    public SyntheticsStepDetail skipped(Boolean skipped) {
        this.skipped = skipped;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not to skip this step.")
    @JsonProperty(value="skipped")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSkipped() {
        return this.skipped;
    }

    public void setSkipped(Boolean skipped) {
        this.skipped = skipped;
    }

    public SyntheticsStepDetail snapshotBucketKey(Boolean snapshotBucketKey) {
        this.snapshotBucketKey = snapshotBucketKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not snapshots where collected by the test.")
    @JsonProperty(value="snapshotBucketKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSnapshotBucketKey() {
        return this.snapshotBucketKey;
    }

    public void setSnapshotBucketKey(Boolean snapshotBucketKey) {
        this.snapshotBucketKey = snapshotBucketKey;
    }

    public SyntheticsStepDetail stepId(Long stepId) {
        this.stepId = stepId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The step ID.")
    @JsonProperty(value="stepId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getStepId() {
        return this.stepId;
    }

    public void setStepId(Long stepId) {
        this.stepId = stepId;
    }

    public SyntheticsStepDetail subTestStepDetails(List<SyntheticsStepDetail> subTestStepDetails) {
        this.subTestStepDetails = subTestStepDetails;
        for (SyntheticsStepDetail item : subTestStepDetails) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SyntheticsStepDetail addSubTestStepDetailsItem(SyntheticsStepDetail subTestStepDetailsItem) {
        if (this.subTestStepDetails == null) {
            this.subTestStepDetails = new ArrayList<SyntheticsStepDetail>();
        }
        this.subTestStepDetails.add(subTestStepDetailsItem);
        this.unparsed |= subTestStepDetailsItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If this steps include a sub-test. [Subtests documentation](https://docs.datadoghq.com/synthetics/browser_tests/advanced_options/#subtests).")
    @JsonProperty(value="subTestStepDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsStepDetail> getSubTestStepDetails() {
        return this.subTestStepDetails;
    }

    public void setSubTestStepDetails(List<SyntheticsStepDetail> subTestStepDetails) {
        this.subTestStepDetails = subTestStepDetails;
    }

    public SyntheticsStepDetail timeToInteractive(Double timeToInteractive) {
        this.timeToInteractive = timeToInteractive;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time before starting the step.")
    @JsonProperty(value="timeToInteractive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getTimeToInteractive() {
        return this.timeToInteractive;
    }

    public void setTimeToInteractive(Double timeToInteractive) {
        this.timeToInteractive = timeToInteractive;
    }

    public SyntheticsStepDetail type(SyntheticsStepType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsStepType getType() {
        return this.type;
    }

    public void setType(SyntheticsStepType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public SyntheticsStepDetail url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to perform the step against.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public SyntheticsStepDetail value(Object value) {
        this.value = value;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Value for the step.")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public SyntheticsStepDetail vitalsMetrics(List<SyntheticsCoreWebVitals> vitalsMetrics) {
        this.vitalsMetrics = vitalsMetrics;
        for (SyntheticsCoreWebVitals item : vitalsMetrics) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SyntheticsStepDetail addVitalsMetricsItem(SyntheticsCoreWebVitals vitalsMetricsItem) {
        if (this.vitalsMetrics == null) {
            this.vitalsMetrics = new ArrayList<SyntheticsCoreWebVitals>();
        }
        this.vitalsMetrics.add(vitalsMetricsItem);
        this.unparsed |= vitalsMetricsItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of Core Web Vitals metrics for the step.")
    @JsonProperty(value="vitalsMetrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsCoreWebVitals> getVitalsMetrics() {
        return this.vitalsMetrics;
    }

    public void setVitalsMetrics(List<SyntheticsCoreWebVitals> vitalsMetrics) {
        this.vitalsMetrics = vitalsMetrics;
    }

    public SyntheticsStepDetail warnings(List<SyntheticsStepDetailWarning> warnings) {
        this.warnings = warnings;
        for (SyntheticsStepDetailWarning item : warnings) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SyntheticsStepDetail addWarningsItem(SyntheticsStepDetailWarning warningsItem) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<SyntheticsStepDetailWarning>();
        }
        this.warnings.add(warningsItem);
        this.unparsed |= warningsItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Warning collected that didn't failed the step.")
    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsStepDetailWarning> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<SyntheticsStepDetailWarning> warnings) {
        this.warnings = warnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsStepDetail syntheticsStepDetail = (SyntheticsStepDetail)o;
        return Objects.equals(this.browserErrors, syntheticsStepDetail.browserErrors) && Objects.equals(this.checkType, syntheticsStepDetail.checkType) && Objects.equals(this.description, syntheticsStepDetail.description) && Objects.equals(this.duration, syntheticsStepDetail.duration) && Objects.equals(this.error, syntheticsStepDetail.error) && Objects.equals(this.playingTab, syntheticsStepDetail.playingTab) && Objects.equals(this.screenshotBucketKey, syntheticsStepDetail.screenshotBucketKey) && Objects.equals(this.skipped, syntheticsStepDetail.skipped) && Objects.equals(this.snapshotBucketKey, syntheticsStepDetail.snapshotBucketKey) && Objects.equals(this.stepId, syntheticsStepDetail.stepId) && Objects.equals(this.subTestStepDetails, syntheticsStepDetail.subTestStepDetails) && Objects.equals(this.timeToInteractive, syntheticsStepDetail.timeToInteractive) && Objects.equals(this.type, syntheticsStepDetail.type) && Objects.equals(this.url, syntheticsStepDetail.url) && Objects.equals(this.value, syntheticsStepDetail.value) && Objects.equals(this.vitalsMetrics, syntheticsStepDetail.vitalsMetrics) && Objects.equals(this.warnings, syntheticsStepDetail.warnings);
    }

    public int hashCode() {
        return Objects.hash(this.browserErrors, this.checkType, this.description, this.duration, this.error, this.playingTab, this.screenshotBucketKey, this.skipped, this.snapshotBucketKey, this.stepId, this.subTestStepDetails, this.timeToInteractive, this.type, this.url, this.value, this.vitalsMetrics, this.warnings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsStepDetail {\n");
        sb.append("    browserErrors: ").append(this.toIndentedString(this.browserErrors)).append("\n");
        sb.append("    checkType: ").append(this.toIndentedString(this.checkType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    playingTab: ").append(this.toIndentedString(this.playingTab)).append("\n");
        sb.append("    screenshotBucketKey: ").append(this.toIndentedString(this.screenshotBucketKey)).append("\n");
        sb.append("    skipped: ").append(this.toIndentedString(this.skipped)).append("\n");
        sb.append("    snapshotBucketKey: ").append(this.toIndentedString(this.snapshotBucketKey)).append("\n");
        sb.append("    stepId: ").append(this.toIndentedString(this.stepId)).append("\n");
        sb.append("    subTestStepDetails: ").append(this.toIndentedString(this.subTestStepDetails)).append("\n");
        sb.append("    timeToInteractive: ").append(this.toIndentedString(this.timeToInteractive)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    vitalsMetrics: ").append(this.toIndentedString(this.vitalsMetrics)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

