/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SyntheticsTestDetails;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object containing an array of Synthetic tests configuration.")
@JsonPropertyOrder(value={"tests"})
public class SyntheticsListTestsResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_TESTS = "tests";
    private List<SyntheticsTestDetails> tests = null;

    public SyntheticsListTestsResponse tests(List<SyntheticsTestDetails> tests) {
        this.tests = tests;
        for (SyntheticsTestDetails item : tests) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SyntheticsListTestsResponse addTestsItem(SyntheticsTestDetails testsItem) {
        if (this.tests == null) {
            this.tests = new ArrayList<SyntheticsTestDetails>();
        }
        this.tests.add(testsItem);
        this.unparsed |= testsItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of Synthetic tests configuration.")
    @JsonProperty(value="tests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsTestDetails> getTests() {
        return this.tests;
    }

    public void setTests(List<SyntheticsTestDetails> tests) {
        this.tests = tests;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsListTestsResponse syntheticsListTestsResponse = (SyntheticsListTestsResponse)o;
        return Objects.equals(this.tests, syntheticsListTestsResponse.tests);
    }

    public int hashCode() {
        return Objects.hash(this.tests);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsListTestsResponse {\n");
        sb.append("    tests: ").append(this.toIndentedString(this.tests)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

