/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=SLOTypeSerializer.class)
public class SLOType {
    public static final SLOType METRIC = new SLOType("metric");
    public static final SLOType MONITOR = new SLOType("monitor");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("metric", "monitor"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    SLOType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((SLOType)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static SLOType fromValue(String value) {
        return new SLOType(value);
    }

    public static class SLOTypeSerializer
    extends StdSerializer<SLOType> {
        public SLOTypeSerializer(Class<SLOType> t) {
            super(t);
        }

        public SLOTypeSerializer() {
            this(null);
        }

        public void serialize(SLOType value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

