/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="An Object of metric units.")
@JsonPropertyOrder(value={"family", "id", "name", "plural", "scale_factor", "short_name"})
public class SLOHistoryMetricsSeriesMetadataUnit {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FAMILY = "family";
    private String family;
    public static final String JSON_PROPERTY_ID = "id";
    private Long id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PLURAL = "plural";
    private JsonNullable<String> plural = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SCALE_FACTOR = "scale_factor";
    private Double scaleFactor;
    public static final String JSON_PROPERTY_SHORT_NAME = "short_name";
    private JsonNullable<String> shortName = JsonNullable.undefined();

    public SLOHistoryMetricsSeriesMetadataUnit family(String family) {
        this.family = family;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The family of metric unit, for example `bytes` is the family for `kibibyte`, `byte`, and `bit` units.")
    @JsonProperty(value="family")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFamily() {
        return this.family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public SLOHistoryMetricsSeriesMetadataUnit id(Long id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the metric unit.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SLOHistoryMetricsSeriesMetadataUnit name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unit of the metric, for instance `byte`.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SLOHistoryMetricsSeriesMetadataUnit plural(String plural) {
        this.plural = JsonNullable.of((Object)plural);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The plural Unit of metric, for instance `bytes`.")
    @JsonIgnore
    public String getPlural() {
        return (String)this.plural.orElse(null);
    }

    @JsonProperty(value="plural")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPlural_JsonNullable() {
        return this.plural;
    }

    @JsonProperty(value="plural")
    public void setPlural_JsonNullable(JsonNullable<String> plural) {
        this.plural = plural;
    }

    public void setPlural(String plural) {
        this.plural = JsonNullable.of((Object)plural);
    }

    public SLOHistoryMetricsSeriesMetadataUnit scaleFactor(Double scaleFactor) {
        this.scaleFactor = scaleFactor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The scale factor of metric unit, for instance `1.0`.")
    @JsonProperty(value="scale_factor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(Double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public SLOHistoryMetricsSeriesMetadataUnit shortName(String shortName) {
        this.shortName = JsonNullable.of((Object)shortName);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A shorter and abbreviated version of the metric unit, for instance `B`.")
    @JsonIgnore
    public String getShortName() {
        return (String)this.shortName.orElse(null);
    }

    @JsonProperty(value="short_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getShortName_JsonNullable() {
        return this.shortName;
    }

    @JsonProperty(value="short_name")
    public void setShortName_JsonNullable(JsonNullable<String> shortName) {
        this.shortName = shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = JsonNullable.of((Object)shortName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOHistoryMetricsSeriesMetadataUnit slOHistoryMetricsSeriesMetadataUnit = (SLOHistoryMetricsSeriesMetadataUnit)o;
        return Objects.equals(this.family, slOHistoryMetricsSeriesMetadataUnit.family) && Objects.equals(this.id, slOHistoryMetricsSeriesMetadataUnit.id) && Objects.equals(this.name, slOHistoryMetricsSeriesMetadataUnit.name) && Objects.equals(this.plural, slOHistoryMetricsSeriesMetadataUnit.plural) && Objects.equals(this.scaleFactor, slOHistoryMetricsSeriesMetadataUnit.scaleFactor) && Objects.equals(this.shortName, slOHistoryMetricsSeriesMetadataUnit.shortName);
    }

    public int hashCode() {
        return Objects.hash(this.family, this.id, this.name, this.plural, this.scaleFactor, this.shortName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOHistoryMetricsSeriesMetadataUnit {\n");
        sb.append("    family: ").append(this.toIndentedString(this.family)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    plural: ").append(this.toIndentedString(this.plural)).append("\n");
        sb.append("    scaleFactor: ").append(this.toIndentedString(this.scaleFactor)).append("\n");
        sb.append("    shortName: ").append(this.toIndentedString(this.shortName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

