/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SLOCorrectionCategory;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The attribute object associated with the SLO correction to be updated.")
@JsonPropertyOrder(value={"category", "description", "end", "start", "timezone"})
public class SLOCorrectionUpdateRequestAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private SLOCorrectionCategory category;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_END = "end";
    private Long end;
    public static final String JSON_PROPERTY_START = "start";
    private Long start;
    public static final String JSON_PROPERTY_TIMEZONE = "timezone";
    private String timezone;

    public SLOCorrectionUpdateRequestAttributes category(SLOCorrectionCategory category) {
        this.category = category;
        this.unparsed |= !category.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SLOCorrectionCategory getCategory() {
        return this.category;
    }

    public void setCategory(SLOCorrectionCategory category) {
        if (!category.isValid()) {
            this.unparsed = true;
        }
        this.category = category;
    }

    public SLOCorrectionUpdateRequestAttributes description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Description of the correction being made.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SLOCorrectionUpdateRequestAttributes end(Long end) {
        this.end = end;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1600000000", value="Ending time of the correction in epoch seconds.")
    @JsonProperty(value="end")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getEnd() {
        return this.end;
    }

    public void setEnd(Long end) {
        this.end = end;
    }

    public SLOCorrectionUpdateRequestAttributes start(Long start) {
        this.start = start;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1600000000", value="Starting time of the correction in epoch seconds.")
    @JsonProperty(value="start")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getStart() {
        return this.start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public SLOCorrectionUpdateRequestAttributes timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="UTC", value="The timezone to display in the UI for the correction times (defaults to \"UTC\").")
    @JsonProperty(value="timezone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOCorrectionUpdateRequestAttributes slOCorrectionUpdateRequestAttributes = (SLOCorrectionUpdateRequestAttributes)o;
        return Objects.equals(this.category, slOCorrectionUpdateRequestAttributes.category) && Objects.equals(this.description, slOCorrectionUpdateRequestAttributes.description) && Objects.equals(this.end, slOCorrectionUpdateRequestAttributes.end) && Objects.equals(this.start, slOCorrectionUpdateRequestAttributes.start) && Objects.equals(this.timezone, slOCorrectionUpdateRequestAttributes.timezone);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.description, this.end, this.start, this.timezone);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOCorrectionUpdateRequestAttributes {\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

