/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.HostMapWidgetDefinitionRequests;
import com.datadog.api.v1.client.model.HostMapWidgetDefinitionStyle;
import com.datadog.api.v1.client.model.HostMapWidgetDefinitionType;
import com.datadog.api.v1.client.model.WidgetCustomLink;
import com.datadog.api.v1.client.model.WidgetNodeType;
import com.datadog.api.v1.client.model.WidgetTextAlign;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The host map widget graphs any metric across your hosts using the same visualization available from the main Host Map page.")
@JsonPropertyOrder(value={"custom_links", "group", "no_group_hosts", "no_metric_hosts", "node_type", "notes", "requests", "scope", "style", "title", "title_align", "title_size", "type"})
public class HostMapWidgetDefinition {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CUSTOM_LINKS = "custom_links";
    private List<WidgetCustomLink> customLinks = null;
    public static final String JSON_PROPERTY_GROUP = "group";
    private List<String> group = null;
    public static final String JSON_PROPERTY_NO_GROUP_HOSTS = "no_group_hosts";
    private Boolean noGroupHosts;
    public static final String JSON_PROPERTY_NO_METRIC_HOSTS = "no_metric_hosts";
    private Boolean noMetricHosts;
    public static final String JSON_PROPERTY_NODE_TYPE = "node_type";
    private WidgetNodeType nodeType;
    public static final String JSON_PROPERTY_NOTES = "notes";
    private String notes;
    public static final String JSON_PROPERTY_REQUESTS = "requests";
    private HostMapWidgetDefinitionRequests requests;
    public static final String JSON_PROPERTY_SCOPE = "scope";
    private List<String> scope = null;
    public static final String JSON_PROPERTY_STYLE = "style";
    private HostMapWidgetDefinitionStyle style;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TITLE_SIZE = "title_size";
    private String titleSize;
    public static final String JSON_PROPERTY_TYPE = "type";
    private HostMapWidgetDefinitionType type = HostMapWidgetDefinitionType.HOSTMAP;

    public HostMapWidgetDefinition() {
    }

    @JsonCreator
    public HostMapWidgetDefinition(@JsonProperty(required=true, value="requests") HostMapWidgetDefinitionRequests requests, @JsonProperty(required=true, value="type") HostMapWidgetDefinitionType type) {
        this.requests = requests;
        this.unparsed |= requests.unparsed;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public HostMapWidgetDefinition customLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
        for (WidgetCustomLink item : customLinks) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public HostMapWidgetDefinition addCustomLinksItem(WidgetCustomLink customLinksItem) {
        if (this.customLinks == null) {
            this.customLinks = new ArrayList<WidgetCustomLink>();
        }
        this.customLinks.add(customLinksItem);
        this.unparsed |= customLinksItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of custom links.")
    @JsonProperty(value="custom_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetCustomLink> getCustomLinks() {
        return this.customLinks;
    }

    public void setCustomLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
    }

    public HostMapWidgetDefinition group(List<String> group) {
        this.group = group;
        return this;
    }

    public HostMapWidgetDefinition addGroupItem(String groupItem) {
        if (this.group == null) {
            this.group = new ArrayList<String>();
        }
        this.group.add(groupItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of tag prefixes to group by.")
    @JsonProperty(value="group")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getGroup() {
        return this.group;
    }

    public void setGroup(List<String> group) {
        this.group = group;
    }

    public HostMapWidgetDefinition noGroupHosts(Boolean noGroupHosts) {
        this.noGroupHosts = noGroupHosts;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether to show the hosts that don\u2019t fit in a group.")
    @JsonProperty(value="no_group_hosts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getNoGroupHosts() {
        return this.noGroupHosts;
    }

    public void setNoGroupHosts(Boolean noGroupHosts) {
        this.noGroupHosts = noGroupHosts;
    }

    public HostMapWidgetDefinition noMetricHosts(Boolean noMetricHosts) {
        this.noMetricHosts = noMetricHosts;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether to show the hosts with no metrics.")
    @JsonProperty(value="no_metric_hosts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getNoMetricHosts() {
        return this.noMetricHosts;
    }

    public void setNoMetricHosts(Boolean noMetricHosts) {
        this.noMetricHosts = noMetricHosts;
    }

    public HostMapWidgetDefinition nodeType(WidgetNodeType nodeType) {
        this.nodeType = nodeType;
        this.unparsed |= !nodeType.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="node_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetNodeType getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(WidgetNodeType nodeType) {
        if (!nodeType.isValid()) {
            this.unparsed = true;
        }
        this.nodeType = nodeType;
    }

    public HostMapWidgetDefinition notes(String notes) {
        this.notes = notes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Notes on the title.")
    @JsonProperty(value="notes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public HostMapWidgetDefinition requests(HostMapWidgetDefinitionRequests requests) {
        this.requests = requests;
        this.unparsed |= requests.unparsed;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="requests")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public HostMapWidgetDefinitionRequests getRequests() {
        return this.requests;
    }

    public void setRequests(HostMapWidgetDefinitionRequests requests) {
        this.requests = requests;
    }

    public HostMapWidgetDefinition scope(List<String> scope) {
        this.scope = scope;
        return this;
    }

    public HostMapWidgetDefinition addScopeItem(String scopeItem) {
        if (this.scope == null) {
            this.scope = new ArrayList<String>();
        }
        this.scope.add(scopeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of tags used to filter the map.")
    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getScope() {
        return this.scope;
    }

    public void setScope(List<String> scope) {
        this.scope = scope;
    }

    public HostMapWidgetDefinition style(HostMapWidgetDefinitionStyle style) {
        this.style = style;
        this.unparsed |= style.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HostMapWidgetDefinitionStyle getStyle() {
        return this.style;
    }

    public void setStyle(HostMapWidgetDefinitionStyle style) {
        this.style = style;
    }

    public HostMapWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Title of the widget.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public HostMapWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        this.unparsed |= !titleAlign.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        if (!titleAlign.isValid()) {
            this.unparsed = true;
        }
        this.titleAlign = titleAlign;
    }

    public HostMapWidgetDefinition titleSize(String titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Size of the title.")
    @JsonProperty(value="title_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(String titleSize) {
        this.titleSize = titleSize;
    }

    public HostMapWidgetDefinition type(HostMapWidgetDefinitionType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public HostMapWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(HostMapWidgetDefinitionType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostMapWidgetDefinition hostMapWidgetDefinition = (HostMapWidgetDefinition)o;
        return Objects.equals(this.customLinks, hostMapWidgetDefinition.customLinks) && Objects.equals(this.group, hostMapWidgetDefinition.group) && Objects.equals(this.noGroupHosts, hostMapWidgetDefinition.noGroupHosts) && Objects.equals(this.noMetricHosts, hostMapWidgetDefinition.noMetricHosts) && Objects.equals(this.nodeType, hostMapWidgetDefinition.nodeType) && Objects.equals(this.notes, hostMapWidgetDefinition.notes) && Objects.equals(this.requests, hostMapWidgetDefinition.requests) && Objects.equals(this.scope, hostMapWidgetDefinition.scope) && Objects.equals(this.style, hostMapWidgetDefinition.style) && Objects.equals(this.title, hostMapWidgetDefinition.title) && Objects.equals(this.titleAlign, hostMapWidgetDefinition.titleAlign) && Objects.equals(this.titleSize, hostMapWidgetDefinition.titleSize) && Objects.equals(this.type, hostMapWidgetDefinition.type);
    }

    public int hashCode() {
        return Objects.hash(this.customLinks, this.group, this.noGroupHosts, this.noMetricHosts, this.nodeType, this.notes, this.requests, this.scope, this.style, this.title, this.titleAlign, this.titleSize, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HostMapWidgetDefinition {\n");
        sb.append("    customLinks: ").append(this.toIndentedString(this.customLinks)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    noGroupHosts: ").append(this.toIndentedString(this.noGroupHosts)).append("\n");
        sb.append("    noMetricHosts: ").append(this.toIndentedString(this.noMetricHosts)).append("\n");
        sb.append("    nodeType: ").append(this.toIndentedString(this.nodeType)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString(this.titleAlign)).append("\n");
        sb.append("    titleSize: ").append(this.toIndentedString(this.titleSize)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

