/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=HeatMapWidgetDefinitionTypeSerializer.class)
public class HeatMapWidgetDefinitionType {
    public static final HeatMapWidgetDefinitionType HEATMAP = new HeatMapWidgetDefinitionType("heatmap");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("heatmap"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    HeatMapWidgetDefinitionType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((HeatMapWidgetDefinitionType)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static HeatMapWidgetDefinitionType fromValue(String value) {
        return new HeatMapWidgetDefinitionType(value);
    }

    public static class HeatMapWidgetDefinitionTypeSerializer
    extends StdSerializer<HeatMapWidgetDefinitionType> {
        public HeatMapWidgetDefinitionTypeSerializer(Class<HeatMapWidgetDefinitionType> t) {
            super(t);
        }

        public HeatMapWidgetDefinitionTypeSerializer() {
            this(null);
        }

        public void serialize(HeatMapWidgetDefinitionType value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

