/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.FormulaAndFunctionQueryDefinition;
import com.datadog.api.v1.client.model.FormulaAndFunctionResponseFormat;
import com.datadog.api.v1.client.model.LogQueryDefinition;
import com.datadog.api.v1.client.model.WidgetFormula;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An updated geomap widget.")
@JsonPropertyOrder(value={"formulas", "log_query", "q", "queries", "response_format", "rum_query", "security_query"})
public class GeomapWidgetRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FORMULAS = "formulas";
    private List<WidgetFormula> formulas = null;
    public static final String JSON_PROPERTY_LOG_QUERY = "log_query";
    private LogQueryDefinition logQuery;
    public static final String JSON_PROPERTY_Q = "q";
    private String q;
    public static final String JSON_PROPERTY_QUERIES = "queries";
    private List<FormulaAndFunctionQueryDefinition> queries = null;
    public static final String JSON_PROPERTY_RESPONSE_FORMAT = "response_format";
    private FormulaAndFunctionResponseFormat responseFormat;
    public static final String JSON_PROPERTY_RUM_QUERY = "rum_query";
    private LogQueryDefinition rumQuery;
    public static final String JSON_PROPERTY_SECURITY_QUERY = "security_query";
    private LogQueryDefinition securityQuery;

    public GeomapWidgetRequest formulas(List<WidgetFormula> formulas) {
        this.formulas = formulas;
        for (WidgetFormula item : formulas) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public GeomapWidgetRequest addFormulasItem(WidgetFormula formulasItem) {
        if (this.formulas == null) {
            this.formulas = new ArrayList<WidgetFormula>();
        }
        this.formulas.add(formulasItem);
        this.unparsed |= formulasItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of formulas that operate on queries. **This feature is currently in beta.**")
    @JsonProperty(value="formulas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetFormula> getFormulas() {
        return this.formulas;
    }

    public void setFormulas(List<WidgetFormula> formulas) {
        this.formulas = formulas;
    }

    public GeomapWidgetRequest logQuery(LogQueryDefinition logQuery) {
        this.logQuery = logQuery;
        this.unparsed |= logQuery.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="log_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getLogQuery() {
        return this.logQuery;
    }

    public void setLogQuery(LogQueryDefinition logQuery) {
        this.logQuery = logQuery;
    }

    public GeomapWidgetRequest q(String q) {
        this.q = q;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The widget metrics query.")
    @JsonProperty(value="q")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public GeomapWidgetRequest queries(List<FormulaAndFunctionQueryDefinition> queries) {
        this.queries = queries;
        for (FormulaAndFunctionQueryDefinition item : queries) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public GeomapWidgetRequest addQueriesItem(FormulaAndFunctionQueryDefinition queriesItem) {
        if (this.queries == null) {
            this.queries = new ArrayList<FormulaAndFunctionQueryDefinition>();
        }
        this.queries.add(queriesItem);
        this.unparsed |= queriesItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of queries that can be returned directly or used in formulas. **This feature is currently in beta.**")
    @JsonProperty(value="queries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FormulaAndFunctionQueryDefinition> getQueries() {
        return this.queries;
    }

    public void setQueries(List<FormulaAndFunctionQueryDefinition> queries) {
        this.queries = queries;
    }

    public GeomapWidgetRequest responseFormat(FormulaAndFunctionResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        this.unparsed |= !responseFormat.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="response_format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FormulaAndFunctionResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(FormulaAndFunctionResponseFormat responseFormat) {
        if (!responseFormat.isValid()) {
            this.unparsed = true;
        }
        this.responseFormat = responseFormat;
    }

    public GeomapWidgetRequest rumQuery(LogQueryDefinition rumQuery) {
        this.rumQuery = rumQuery;
        this.unparsed |= rumQuery.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="rum_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getRumQuery() {
        return this.rumQuery;
    }

    public void setRumQuery(LogQueryDefinition rumQuery) {
        this.rumQuery = rumQuery;
    }

    public GeomapWidgetRequest securityQuery(LogQueryDefinition securityQuery) {
        this.securityQuery = securityQuery;
        this.unparsed |= securityQuery.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="security_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getSecurityQuery() {
        return this.securityQuery;
    }

    public void setSecurityQuery(LogQueryDefinition securityQuery) {
        this.securityQuery = securityQuery;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeomapWidgetRequest geomapWidgetRequest = (GeomapWidgetRequest)o;
        return Objects.equals(this.formulas, geomapWidgetRequest.formulas) && Objects.equals(this.logQuery, geomapWidgetRequest.logQuery) && Objects.equals(this.q, geomapWidgetRequest.q) && Objects.equals(this.queries, geomapWidgetRequest.queries) && Objects.equals(this.responseFormat, geomapWidgetRequest.responseFormat) && Objects.equals(this.rumQuery, geomapWidgetRequest.rumQuery) && Objects.equals(this.securityQuery, geomapWidgetRequest.securityQuery);
    }

    public int hashCode() {
        return Objects.hash(this.formulas, this.logQuery, this.q, this.queries, this.responseFormat, this.rumQuery, this.securityQuery);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeomapWidgetRequest {\n");
        sb.append("    formulas: ").append(this.toIndentedString(this.formulas)).append("\n");
        sb.append("    logQuery: ").append(this.toIndentedString(this.logQuery)).append("\n");
        sb.append("    q: ").append(this.toIndentedString(this.q)).append("\n");
        sb.append("    queries: ").append(this.toIndentedString(this.queries)).append("\n");
        sb.append("    responseFormat: ").append(this.toIndentedString(this.responseFormat)).append("\n");
        sb.append("    rumQuery: ").append(this.toIndentedString(this.rumQuery)).append("\n");
        sb.append("    securityQuery: ").append(this.toIndentedString(this.securityQuery)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

