/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.FormulaAndFunctionEventAggregation;
import com.datadog.api.v1.client.model.QuerySortOrder;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Options for sorting group by results.")
@JsonPropertyOrder(value={"aggregation", "metric", "order"})
public class FormulaAndFunctionEventQueryGroupBySort {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGGREGATION = "aggregation";
    private FormulaAndFunctionEventAggregation aggregation;
    public static final String JSON_PROPERTY_METRIC = "metric";
    private String metric;
    public static final String JSON_PROPERTY_ORDER = "order";
    private QuerySortOrder order = QuerySortOrder.DESC;

    public FormulaAndFunctionEventQueryGroupBySort() {
    }

    @JsonCreator
    public FormulaAndFunctionEventQueryGroupBySort(@JsonProperty(required=true, value="aggregation") FormulaAndFunctionEventAggregation aggregation) {
        this.aggregation = aggregation;
        this.unparsed |= !aggregation.isValid();
    }

    public FormulaAndFunctionEventQueryGroupBySort aggregation(FormulaAndFunctionEventAggregation aggregation) {
        this.aggregation = aggregation;
        this.unparsed |= !aggregation.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="aggregation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FormulaAndFunctionEventAggregation getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(FormulaAndFunctionEventAggregation aggregation) {
        if (!aggregation.isValid()) {
            this.unparsed = true;
        }
        this.aggregation = aggregation;
    }

    public FormulaAndFunctionEventQueryGroupBySort metric(String metric) {
        this.metric = metric;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Metric used for sorting group by results.")
    @JsonProperty(value="metric")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public FormulaAndFunctionEventQueryGroupBySort order(QuerySortOrder order) {
        this.order = order;
        this.unparsed |= !order.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public QuerySortOrder getOrder() {
        return this.order;
    }

    public void setOrder(QuerySortOrder order) {
        if (!order.isValid()) {
            this.unparsed = true;
        }
        this.order = order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormulaAndFunctionEventQueryGroupBySort formulaAndFunctionEventQueryGroupBySort = (FormulaAndFunctionEventQueryGroupBySort)o;
        return Objects.equals(this.aggregation, formulaAndFunctionEventQueryGroupBySort.aggregation) && Objects.equals(this.metric, formulaAndFunctionEventQueryGroupBySort.metric) && Objects.equals(this.order, formulaAndFunctionEventQueryGroupBySort.order);
    }

    public int hashCode() {
        return Objects.hash(this.aggregation, this.metric, this.order);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FormulaAndFunctionEventQueryGroupBySort {\n");
        sb.append("    aggregation: ").append(this.toIndentedString(this.aggregation)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

