/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.ApplicationKey;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An application key response.")
@JsonPropertyOrder(value={"application_keys"})
public class ApplicationKeyListResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_APPLICATION_KEYS = "application_keys";
    private List<ApplicationKey> applicationKeys = null;

    public ApplicationKeyListResponse applicationKeys(List<ApplicationKey> applicationKeys) {
        this.applicationKeys = applicationKeys;
        for (ApplicationKey item : applicationKeys) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ApplicationKeyListResponse addApplicationKeysItem(ApplicationKey applicationKeysItem) {
        if (this.applicationKeys == null) {
            this.applicationKeys = new ArrayList<ApplicationKey>();
        }
        this.applicationKeys.add(applicationKeysItem);
        this.unparsed |= applicationKeysItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of application keys.")
    @JsonProperty(value="application_keys")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ApplicationKey> getApplicationKeys() {
        return this.applicationKeys;
    }

    public void setApplicationKeys(List<ApplicationKey> applicationKeys) {
        this.applicationKeys = applicationKeys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationKeyListResponse applicationKeyListResponse = (ApplicationKeyListResponse)o;
        return Objects.equals(this.applicationKeys, applicationKeyListResponse.applicationKeys);
    }

    public int hashCode() {
        return Objects.hash(this.applicationKeys);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationKeyListResponse {\n");
        sb.append("    applicationKeys: ").append(this.toIndentedString(this.applicationKeys)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

