/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.SlackIntegrationChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class SlackIntegrationApi {
    private ApiClient apiClient;

    public SlackIntegrationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SlackIntegrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SlackIntegrationChannel createSlackIntegrationChannel(String accountName, SlackIntegrationChannel body) throws ApiException {
        return this.createSlackIntegrationChannelWithHttpInfo(accountName, body).getData();
    }

    public ApiResponse<SlackIntegrationChannel> createSlackIntegrationChannelWithHttpInfo(String accountName, SlackIntegrationChannel body) throws ApiException {
        SlackIntegrationChannel localVarPostBody = body;
        if (accountName == null) {
            throw new ApiException(400, "Missing the required parameter 'accountName' when calling createSlackIntegrationChannel");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSlackIntegrationChannel");
        }
        String localVarPath = "/api/v1/integration/slack/configuration/accounts/{account_name}/channels".replaceAll("\\{account_name\\}", this.apiClient.escapeString(accountName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createSlackIntegrationChannel");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SlackIntegrationChannel> localVarReturnType = new GenericType<SlackIntegrationChannel>(){};
        return this.apiClient.invokeAPI("SlackIntegrationApi.createSlackIntegrationChannel", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SlackIntegrationChannel getSlackIntegrationChannel(String accountName, String channelName) throws ApiException {
        return this.getSlackIntegrationChannelWithHttpInfo(accountName, channelName).getData();
    }

    public ApiResponse<SlackIntegrationChannel> getSlackIntegrationChannelWithHttpInfo(String accountName, String channelName) throws ApiException {
        Object localVarPostBody = null;
        if (accountName == null) {
            throw new ApiException(400, "Missing the required parameter 'accountName' when calling getSlackIntegrationChannel");
        }
        if (channelName == null) {
            throw new ApiException(400, "Missing the required parameter 'channelName' when calling getSlackIntegrationChannel");
        }
        String localVarPath = "/api/v1/integration/slack/configuration/accounts/{account_name}/channels/{channel_name}".replaceAll("\\{account_name\\}", this.apiClient.escapeString(accountName.toString())).replaceAll("\\{channel_name\\}", this.apiClient.escapeString(channelName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getSlackIntegrationChannel");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SlackIntegrationChannel> localVarReturnType = new GenericType<SlackIntegrationChannel>(){};
        return this.apiClient.invokeAPI("SlackIntegrationApi.getSlackIntegrationChannel", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public List<SlackIntegrationChannel> getSlackIntegrationChannels(String accountName) throws ApiException {
        return this.getSlackIntegrationChannelsWithHttpInfo(accountName).getData();
    }

    public ApiResponse<List<SlackIntegrationChannel>> getSlackIntegrationChannelsWithHttpInfo(String accountName) throws ApiException {
        Object localVarPostBody = null;
        if (accountName == null) {
            throw new ApiException(400, "Missing the required parameter 'accountName' when calling getSlackIntegrationChannels");
        }
        String localVarPath = "/api/v1/integration/slack/configuration/accounts/{account_name}/channels".replaceAll("\\{account_name\\}", this.apiClient.escapeString(accountName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getSlackIntegrationChannels");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<List<SlackIntegrationChannel>> localVarReturnType = new GenericType<List<SlackIntegrationChannel>>(){};
        return this.apiClient.invokeAPI("SlackIntegrationApi.getSlackIntegrationChannels", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void removeSlackIntegrationChannel(String accountName, String channelName) throws ApiException {
        this.removeSlackIntegrationChannelWithHttpInfo(accountName, channelName);
    }

    public ApiResponse<Void> removeSlackIntegrationChannelWithHttpInfo(String accountName, String channelName) throws ApiException {
        Object localVarPostBody = null;
        if (accountName == null) {
            throw new ApiException(400, "Missing the required parameter 'accountName' when calling removeSlackIntegrationChannel");
        }
        if (channelName == null) {
            throw new ApiException(400, "Missing the required parameter 'channelName' when calling removeSlackIntegrationChannel");
        }
        String localVarPath = "/api/v1/integration/slack/configuration/accounts/{account_name}/channels/{channel_name}".replaceAll("\\{account_name\\}", this.apiClient.escapeString(accountName.toString())).replaceAll("\\{channel_name\\}", this.apiClient.escapeString(channelName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "removeSlackIntegrationChannel");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("SlackIntegrationApi.removeSlackIntegrationChannel", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public SlackIntegrationChannel updateSlackIntegrationChannel(String accountName, String channelName, SlackIntegrationChannel body) throws ApiException {
        return this.updateSlackIntegrationChannelWithHttpInfo(accountName, channelName, body).getData();
    }

    public ApiResponse<SlackIntegrationChannel> updateSlackIntegrationChannelWithHttpInfo(String accountName, String channelName, SlackIntegrationChannel body) throws ApiException {
        SlackIntegrationChannel localVarPostBody = body;
        if (accountName == null) {
            throw new ApiException(400, "Missing the required parameter 'accountName' when calling updateSlackIntegrationChannel");
        }
        if (channelName == null) {
            throw new ApiException(400, "Missing the required parameter 'channelName' when calling updateSlackIntegrationChannel");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateSlackIntegrationChannel");
        }
        String localVarPath = "/api/v1/integration/slack/configuration/accounts/{account_name}/channels/{channel_name}".replaceAll("\\{account_name\\}", this.apiClient.escapeString(accountName.toString())).replaceAll("\\{channel_name\\}", this.apiClient.escapeString(channelName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateSlackIntegrationChannel");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SlackIntegrationChannel> localVarReturnType = new GenericType<SlackIntegrationChannel>(){};
        return this.apiClient.invokeAPI("SlackIntegrationApi.updateSlackIntegrationChannel", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }
}

