/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.IncidentRelatedObject;
import com.datadog.api.v2.client.model.IncidentServiceCreateRequest;
import com.datadog.api.v2.client.model.IncidentServiceResponse;
import com.datadog.api.v2.client.model.IncidentServiceUpdateRequest;
import com.datadog.api.v2.client.model.IncidentServicesResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class IncidentServicesApi {
    private ApiClient apiClient;

    public IncidentServicesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IncidentServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public IncidentServiceResponse createIncidentService(IncidentServiceCreateRequest body) throws ApiException {
        return this.createIncidentServiceWithHttpInfo(body).getData();
    }

    public ApiResponse<IncidentServiceResponse> createIncidentServiceWithHttpInfo(IncidentServiceCreateRequest body) throws ApiException {
        IncidentServiceCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createIncidentService");
        }
        String localVarPath = "/api/v2/services";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createIncidentService");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentServiceResponse> localVarReturnType = new GenericType<IncidentServiceResponse>(){};
        return this.apiClient.invokeAPI("IncidentServicesApi.createIncidentService", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void deleteIncidentService(String serviceId) throws ApiException {
        this.deleteIncidentServiceWithHttpInfo(serviceId);
    }

    public ApiResponse<Void> deleteIncidentServiceWithHttpInfo(String serviceId) throws ApiException {
        Object localVarPostBody = null;
        if (serviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceId' when calling deleteIncidentService");
        }
        String localVarPath = "/api/v2/services/{service_id}".replaceAll("\\{service_id\\}", this.apiClient.escapeString(serviceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteIncidentService");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("IncidentServicesApi.deleteIncidentService", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public IncidentServiceResponse getIncidentService(String serviceId) throws ApiException {
        return this.getIncidentServiceWithHttpInfo(serviceId, new GetIncidentServiceOptionalParameters()).getData();
    }

    public IncidentServiceResponse getIncidentService(String serviceId, GetIncidentServiceOptionalParameters parameters) throws ApiException {
        return this.getIncidentServiceWithHttpInfo(serviceId, parameters).getData();
    }

    public ApiResponse<IncidentServiceResponse> getIncidentServiceWithHttpInfo(String serviceId, GetIncidentServiceOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (serviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceId' when calling getIncidentService");
        }
        IncidentRelatedObject include = parameters.include;
        String localVarPath = "/api/v2/services/{service_id}".replaceAll("\\{service_id\\}", this.apiClient.escapeString(serviceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", (Object)include));
        localVarHeaderParams.put("DD-OPERATION-ID", "getIncidentService");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentServiceResponse> localVarReturnType = new GenericType<IncidentServiceResponse>(){};
        return this.apiClient.invokeAPI("IncidentServicesApi.getIncidentService", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public IncidentServicesResponse listIncidentServices() throws ApiException {
        return this.listIncidentServicesWithHttpInfo(new ListIncidentServicesOptionalParameters()).getData();
    }

    public IncidentServicesResponse listIncidentServices(ListIncidentServicesOptionalParameters parameters) throws ApiException {
        return this.listIncidentServicesWithHttpInfo(parameters).getData();
    }

    public ApiResponse<IncidentServicesResponse> listIncidentServicesWithHttpInfo(ListIncidentServicesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        IncidentRelatedObject include = parameters.include;
        Long pageSize = parameters.pageSize;
        Long pageOffset = parameters.pageOffset;
        String filter = parameters.filter;
        String localVarPath = "/api/v2/services";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", (Object)include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarHeaderParams.put("DD-OPERATION-ID", "listIncidentServices");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentServicesResponse> localVarReturnType = new GenericType<IncidentServicesResponse>(){};
        return this.apiClient.invokeAPI("IncidentServicesApi.listIncidentServices", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public IncidentServiceResponse updateIncidentService(String serviceId, IncidentServiceUpdateRequest body) throws ApiException {
        return this.updateIncidentServiceWithHttpInfo(serviceId, body).getData();
    }

    public ApiResponse<IncidentServiceResponse> updateIncidentServiceWithHttpInfo(String serviceId, IncidentServiceUpdateRequest body) throws ApiException {
        IncidentServiceUpdateRequest localVarPostBody = body;
        if (serviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceId' when calling updateIncidentService");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateIncidentService");
        }
        String localVarPath = "/api/v2/services/{service_id}".replaceAll("\\{service_id\\}", this.apiClient.escapeString(serviceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateIncidentService");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentServiceResponse> localVarReturnType = new GenericType<IncidentServiceResponse>(){};
        return this.apiClient.invokeAPI("IncidentServicesApi.updateIncidentService", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public static class ListIncidentServicesOptionalParameters {
        private IncidentRelatedObject include;
        private Long pageSize;
        private Long pageOffset;
        private String filter;

        public ListIncidentServicesOptionalParameters include(IncidentRelatedObject include) {
            this.include = include;
            return this;
        }

        public ListIncidentServicesOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListIncidentServicesOptionalParameters pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }

        public ListIncidentServicesOptionalParameters filter(String filter) {
            this.filter = filter;
            return this;
        }
    }

    public static class GetIncidentServiceOptionalParameters {
        private IncidentRelatedObject include;

        public GetIncidentServiceOptionalParameters include(IncidentRelatedObject include) {
            this.include = include;
            return this;
        }
    }
}

