/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The metadata for the current pagination.")
@JsonPropertyOrder(value={"limit", "next_record_id", "total_number_of_records"})
public class UsageAttributionPagination {
    public static final String JSON_PROPERTY_LIMIT = "limit";
    private Long limit;
    public static final String JSON_PROPERTY_NEXT_RECORD_ID = "next_record_id";
    private String nextRecordId;
    public static final String JSON_PROPERTY_TOTAL_NUMBER_OF_RECORDS = "total_number_of_records";
    private Long totalNumberOfRecords;

    public UsageAttributionPagination limit(Long limit) {
        this.limit = limit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Maximum amount of records to be returned.")
    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getLimit() {
        return this.limit;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public UsageAttributionPagination nextRecordId(String nextRecordId) {
        this.nextRecordId = nextRecordId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The cursor to use to get the next results, if any. To make the next request, use the same parameters with the addition of this next_record_id.")
    @JsonProperty(value="next_record_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNextRecordId() {
        return this.nextRecordId;
    }

    public void setNextRecordId(String nextRecordId) {
        this.nextRecordId = nextRecordId;
    }

    public UsageAttributionPagination totalNumberOfRecords(Long totalNumberOfRecords) {
        this.totalNumberOfRecords = totalNumberOfRecords;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total number of records. (deprecated after May 1st, 2021)")
    @JsonProperty(value="total_number_of_records")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTotalNumberOfRecords() {
        return this.totalNumberOfRecords;
    }

    public void setTotalNumberOfRecords(Long totalNumberOfRecords) {
        this.totalNumberOfRecords = totalNumberOfRecords;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageAttributionPagination usageAttributionPagination = (UsageAttributionPagination)o;
        return Objects.equals(this.limit, usageAttributionPagination.limit) && Objects.equals(this.nextRecordId, usageAttributionPagination.nextRecordId) && Objects.equals(this.totalNumberOfRecords, usageAttributionPagination.totalNumberOfRecords);
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.nextRecordId, this.totalNumberOfRecords);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageAttributionPagination {\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    nextRecordId: ").append(this.toIndentedString(this.nextRecordId)).append("\n");
        sb.append("    totalNumberOfRecords: ").append(this.toIndentedString(this.totalNumberOfRecords)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

