/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SLOHistoryMetricsSeriesMetadataUnit;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Query metadata.")
@JsonPropertyOrder(value={"aggr", "expression", "metric", "query_index", "scope", "unit"})
public class SLOHistoryMetricsSeriesMetadata {
    public static final String JSON_PROPERTY_AGGR = "aggr";
    private String aggr;
    public static final String JSON_PROPERTY_EXPRESSION = "expression";
    private String expression;
    public static final String JSON_PROPERTY_METRIC = "metric";
    private String metric;
    public static final String JSON_PROPERTY_QUERY_INDEX = "query_index";
    private Long queryIndex;
    public static final String JSON_PROPERTY_SCOPE = "scope";
    private String scope;
    public static final String JSON_PROPERTY_UNIT = "unit";
    private JsonNullable<List<SLOHistoryMetricsSeriesMetadataUnit>> unit = JsonNullable.undefined();

    public SLOHistoryMetricsSeriesMetadata aggr(String aggr) {
        this.aggr = aggr;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Query aggregator function.")
    @JsonProperty(value="aggr")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAggr() {
        return this.aggr;
    }

    public void setAggr(String aggr) {
        this.aggr = aggr;
    }

    public SLOHistoryMetricsSeriesMetadata expression(String expression) {
        this.expression = expression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Query expression.")
    @JsonProperty(value="expression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public SLOHistoryMetricsSeriesMetadata metric(String metric) {
        this.metric = metric;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Query metric used.")
    @JsonProperty(value="metric")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public SLOHistoryMetricsSeriesMetadata queryIndex(Long queryIndex) {
        this.queryIndex = queryIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Query index from original combined query.")
    @JsonProperty(value="query_index")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getQueryIndex() {
        return this.queryIndex;
    }

    public void setQueryIndex(Long queryIndex) {
        this.queryIndex = queryIndex;
    }

    public SLOHistoryMetricsSeriesMetadata scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Query scope.")
    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public SLOHistoryMetricsSeriesMetadata unit(List<SLOHistoryMetricsSeriesMetadataUnit> unit) {
        this.unit = JsonNullable.of(unit);
        return this;
    }

    public SLOHistoryMetricsSeriesMetadata addUnitItem(SLOHistoryMetricsSeriesMetadataUnit unitItem) {
        if (this.unit == null || !this.unit.isPresent()) {
            this.unit = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.unit.get()).add(unitItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[{\"family\":\"bytes\",\"id\":2,\"name\":\"byte\",\"plural\":\"bytes\",\"scale_factor\":1.0,\"short_name\":\"B\"},null]", value="An array of metric units that contains up to two unit objects. For example, bytes represents one unit object and bytes per second represents two unit objects. If a metric query only has one unit object, the second array element is null.")
    @JsonIgnore
    public List<SLOHistoryMetricsSeriesMetadataUnit> getUnit() {
        return (List)this.unit.orElse(null);
    }

    @JsonProperty(value="unit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<SLOHistoryMetricsSeriesMetadataUnit>> getUnit_JsonNullable() {
        return this.unit;
    }

    @JsonProperty(value="unit")
    public void setUnit_JsonNullable(JsonNullable<List<SLOHistoryMetricsSeriesMetadataUnit>> unit) {
        this.unit = unit;
    }

    public void setUnit(List<SLOHistoryMetricsSeriesMetadataUnit> unit) {
        this.unit = JsonNullable.of(unit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOHistoryMetricsSeriesMetadata slOHistoryMetricsSeriesMetadata = (SLOHistoryMetricsSeriesMetadata)o;
        return Objects.equals(this.aggr, slOHistoryMetricsSeriesMetadata.aggr) && Objects.equals(this.expression, slOHistoryMetricsSeriesMetadata.expression) && Objects.equals(this.metric, slOHistoryMetricsSeriesMetadata.metric) && Objects.equals(this.queryIndex, slOHistoryMetricsSeriesMetadata.queryIndex) && Objects.equals(this.scope, slOHistoryMetricsSeriesMetadata.scope) && Objects.equals(this.unit, slOHistoryMetricsSeriesMetadata.unit);
    }

    public int hashCode() {
        return Objects.hash(this.aggr, this.expression, this.metric, this.queryIndex, this.scope, this.unit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOHistoryMetricsSeriesMetadata {\n");
        sb.append("    aggr: ").append(this.toIndentedString(this.aggr)).append("\n");
        sb.append("    expression: ").append(this.toIndentedString(this.expression)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    queryIndex: ").append(this.toIndentedString(this.queryIndex)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

