/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Absolute timeframe.")
@JsonPropertyOrder(value={"end", "live", "start"})
public class NotebookAbsoluteTime {
    public static final String JSON_PROPERTY_END = "end";
    private OffsetDateTime end;
    public static final String JSON_PROPERTY_LIVE = "live";
    private Boolean live;
    public static final String JSON_PROPERTY_START = "start";
    private OffsetDateTime start;

    public NotebookAbsoluteTime() {
    }

    @JsonCreator
    public NotebookAbsoluteTime(@JsonProperty(required=true, value="end") OffsetDateTime end, @JsonProperty(required=true, value="start") OffsetDateTime start) {
        this.end = end;
        this.start = start;
    }

    public NotebookAbsoluteTime end(OffsetDateTime end) {
        this.end = end;
        return this;
    }

    @ApiModelProperty(example="2021-02-24T20:18:28Z", required=true, value="The end time.")
    @JsonProperty(value="end")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getEnd() {
        return this.end;
    }

    public void setEnd(OffsetDateTime end) {
        this.end = end;
    }

    public NotebookAbsoluteTime live(Boolean live) {
        this.live = live;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the timeframe should be shifted to end at the current time.")
    @JsonProperty(value="live")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getLive() {
        return this.live;
    }

    public void setLive(Boolean live) {
        this.live = live;
    }

    public NotebookAbsoluteTime start(OffsetDateTime start) {
        this.start = start;
        return this;
    }

    @ApiModelProperty(example="2021-02-24T19:18:28Z", required=true, value="The start time.")
    @JsonProperty(value="start")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getStart() {
        return this.start;
    }

    public void setStart(OffsetDateTime start) {
        this.start = start;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotebookAbsoluteTime notebookAbsoluteTime = (NotebookAbsoluteTime)o;
        return Objects.equals(this.end, notebookAbsoluteTime.end) && Objects.equals(this.live, notebookAbsoluteTime.live) && Objects.equals(this.start, notebookAbsoluteTime.start);
    }

    public int hashCode() {
        return Objects.hash(this.end, this.live, this.start);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotebookAbsoluteTime {\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("    live: ").append(this.toIndentedString(this.live)).append("\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

