/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The style to apply to the widget.")
@JsonPropertyOrder(value={"palette", "palette_flip"})
public class GeomapWidgetDefinitionStyle {
    public static final String JSON_PROPERTY_PALETTE = "palette";
    private String palette;
    public static final String JSON_PROPERTY_PALETTE_FLIP = "palette_flip";
    private Boolean paletteFlip;

    public GeomapWidgetDefinitionStyle() {
    }

    @JsonCreator
    public GeomapWidgetDefinitionStyle(@JsonProperty(required=true, value="palette") String palette, @JsonProperty(required=true, value="palette_flip") Boolean paletteFlip) {
        this.palette = palette;
        this.paletteFlip = paletteFlip;
    }

    public GeomapWidgetDefinitionStyle palette(String palette) {
        this.palette = palette;
        return this;
    }

    @ApiModelProperty(example="hostmap_blues", required=true, value="The color palette to apply to the widget.")
    @JsonProperty(value="palette")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPalette() {
        return this.palette;
    }

    public void setPalette(String palette) {
        this.palette = palette;
    }

    public GeomapWidgetDefinitionStyle paletteFlip(Boolean paletteFlip) {
        this.paletteFlip = paletteFlip;
        return this;
    }

    @ApiModelProperty(example="false", required=true, value="Whether to flip the palette tones.")
    @JsonProperty(value="palette_flip")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getPaletteFlip() {
        return this.paletteFlip;
    }

    public void setPaletteFlip(Boolean paletteFlip) {
        this.paletteFlip = paletteFlip;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeomapWidgetDefinitionStyle geomapWidgetDefinitionStyle = (GeomapWidgetDefinitionStyle)o;
        return Objects.equals(this.palette, geomapWidgetDefinitionStyle.palette) && Objects.equals(this.paletteFlip, geomapWidgetDefinitionStyle.paletteFlip);
    }

    public int hashCode() {
        return Objects.hash(this.palette, this.paletteFlip);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeomapWidgetDefinitionStyle {\n");
        sb.append("    palette: ").append(this.toIndentedString(this.palette)).append("\n");
        sb.append("    paletteFlip: ").append(this.toIndentedString(this.paletteFlip)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

