/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SLOHistoryMetricsSeriesMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A representation of `metric` based SLO time series for the provided queries. This is the same response type from `batch_query` endpoint.")
@JsonPropertyOrder(value={"count", "metadata", "sum", "values"})
public class SLOHistoryMetricsSeries {
    public static final String JSON_PROPERTY_COUNT = "count";
    private Long count;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private SLOHistoryMetricsSeriesMetadata metadata;
    public static final String JSON_PROPERTY_SUM = "sum";
    private Double sum;
    public static final String JSON_PROPERTY_VALUES = "values";
    private List<Double> values = new ArrayList<Double>();

    public SLOHistoryMetricsSeries() {
    }

    @JsonCreator
    public SLOHistoryMetricsSeries(@JsonProperty(required=true, value="count") Long count, @JsonProperty(required=true, value="metadata") SLOHistoryMetricsSeriesMetadata metadata, @JsonProperty(required=true, value="sum") Double sum, @JsonProperty(required=true, value="values") List<Double> values) {
        this.count = count;
        this.metadata = metadata;
        this.sum = sum;
        this.values = values;
    }

    public SLOHistoryMetricsSeries count(Long count) {
        this.count = count;
        return this;
    }

    @ApiModelProperty(example="0", required=true, value="Count of submitted metrics.")
    @JsonProperty(value="count")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getCount() {
        return this.count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public SLOHistoryMetricsSeries metadata(SLOHistoryMetricsSeriesMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SLOHistoryMetricsSeriesMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(SLOHistoryMetricsSeriesMetadata metadata) {
        this.metadata = metadata;
    }

    public SLOHistoryMetricsSeries sum(Double sum) {
        this.sum = sum;
        return this;
    }

    @ApiModelProperty(example="0.0", required=true, value="Total sum of the query.")
    @JsonProperty(value="sum")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Double getSum() {
        return this.sum;
    }

    public void setSum(Double sum) {
        this.sum = sum;
    }

    public SLOHistoryMetricsSeries values(List<Double> values) {
        this.values = values;
        return this;
    }

    public SLOHistoryMetricsSeries addValuesItem(Double valuesItem) {
        this.values.add(valuesItem);
        return this;
    }

    @ApiModelProperty(example="[]", required=true, value="The query values for each metric.")
    @JsonProperty(value="values")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Double> getValues() {
        return this.values;
    }

    public void setValues(List<Double> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOHistoryMetricsSeries slOHistoryMetricsSeries = (SLOHistoryMetricsSeries)o;
        return Objects.equals(this.count, slOHistoryMetricsSeries.count) && Objects.equals(this.metadata, slOHistoryMetricsSeries.metadata) && Objects.equals(this.sum, slOHistoryMetricsSeries.sum) && Objects.equals(this.values, slOHistoryMetricsSeries.values);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.metadata, this.sum, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOHistoryMetricsSeries {\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    sum: ").append(this.toIndentedString(this.sum)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

